/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.crypto.secretshare;

import com.ionic.sdk.cipher.aes.AesGcmCipher;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.rng.CryptoRng;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.crypto.CryptoUtils;
import com.ionic.sdk.crypto.secretshare.SecretShareBucket;
import com.ionic.sdk.crypto.secretshare.SecretShareKey;
import com.ionic.sdk.crypto.shamir.Scheme;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import com.ionic.sdk.json.JsonTarget;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;

public final class SecretShareGenerator {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Properties properties;
    private final Collection<SecretShareBucket> buckets;
    private static final int SALT_BITS = 64;
    private static final int PBKDF_ITERATIONS = 10000;
    private static final int CRYPTOPP_OFFSET = 4;

    public SecretShareGenerator(Properties properties) {
        this.properties = properties;
        this.buckets = new ArrayList<SecretShareBucket>();
    }

    public void addBucket(SecretShareBucket bucket) {
        this.buckets.add(bucket);
    }

    public SecretShareKey generate() throws IonicException {
        ArrayList<byte[]> shares = new ArrayList<byte[]>();
        byte[] secret = new byte[32];
        for (SecretShareBucket secretShareBucket : this.buckets) {
            byte[] secretIt = new byte[32];
            ArrayList<String> labels = new ArrayList<String>(secretShareBucket.getKeys());
            int threshold = secretShareBucket.getThreshold();
            if (threshold == labels.size()) {
                this.createKeyFromInputs(labels, secretIt);
            } else if (threshold < labels.size()) {
                this.createThresholdKeyFromInputs(labels, threshold, secretIt, shares);
            } else {
                throw new IonicException(40005);
            }
            this.accumulateXOR(secret, secretIt);
        }
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (byte[] share : shares) {
            JsonTarget.addNotNull(jsonArrayBuilder, CryptoUtils.binToBase64(share));
        }
        byte[] byArray = new CryptoRng().rand(new byte[8]);
        byte[] secretFinal = CryptoUtils.pbkdf2ToBytes(secret, byArray, 10000L, secret.length);
        JsonObject jsonPersist = Json.createObjectBuilder().add("shares", (JsonValue)jsonArrayBuilder.build()).add("salt", CryptoUtils.binToBase64(byArray)).build();
        return new SecretShareKey(CryptoUtils.binToHex(secretFinal), JsonIO.write(jsonPersist, true));
    }

    public SecretShareKey recover(String data) throws IonicException {
        JsonObject jsonPersist = JsonIO.readObject(data, 40010);
        JsonArray jsonShares = JsonSource.getJsonArray(jsonPersist, "shares");
        String jsonSalt = JsonSource.getString(jsonPersist, "salt");
        ArrayList<byte[]> shares = new ArrayList<byte[]>();
        for (JsonValue jsonValue : jsonShares) {
            String jsonShare = JsonSource.toString(jsonValue);
            shares.add(CryptoUtils.base64ToBin(jsonShare));
        }
        byte[] salt = CryptoUtils.base64ToBin(jsonSalt);
        byte[] secret = new byte[32];
        for (SecretShareBucket bucket : this.buckets) {
            byte[] secretIt = new byte[32];
            ArrayList<String> labels = new ArrayList<String>(bucket.getKeys());
            int threshold = bucket.getThreshold();
            if (threshold == labels.size()) {
                this.createKeyFromInputs(labels, secretIt);
            } else if (threshold < labels.size()) {
                this.restoreThresholdKeyFromInputs(labels, threshold, secretIt, shares);
            } else {
                throw new IonicException(40005);
            }
            this.accumulateXOR(secret, secretIt);
        }
        byte[] secretFinal = CryptoUtils.pbkdf2ToBytes(secret, salt, 10000L, secret.length);
        return new SecretShareKey(CryptoUtils.binToHex(secretFinal), data);
    }

    private void createKeyFromInputs(Collection<String> keys, byte[] secret) throws IonicException {
        byte[] salt = Transcoder.utf8().decode(Value.joinCollection("|", keys));
        for (String key : keys) {
            byte[] value = Transcoder.utf8().decode(this.properties.getProperty(key));
            byte[] valuePBKDF = Value.isEmpty(value) ? new byte[8] : value;
            byte[] secretIt = CryptoUtils.pbkdf2ToBytes(valuePBKDF, salt, 10000L, secret.length);
            this.accumulateXOR(secret, secretIt);
        }
    }

    private void createThresholdKeyFromInputs(List<String> keys, int threshold, byte[] secret, List<byte[]> shares) throws IonicException {
        byte[] salt = Transcoder.utf8().decode(Value.joinCollection("|", keys));
        new CryptoRng().rand(secret);
        Scheme scheme = new Scheme(keys.size(), threshold);
        List<byte[]> split = scheme.split(secret);
        AesGcmCipher cipher = new AesGcmCipher();
        for (int i = 0; i < split.size(); ++i) {
            String key = keys.get(i);
            byte[] value = Transcoder.utf8().decode(this.properties.getProperty(key));
            byte[] valuePBKDF = Value.isEmpty(value) ? new CryptoRng().rand(new byte[8]) : value;
            byte[] secretIt = CryptoUtils.pbkdf2ToBytes(valuePBKDF, salt, 10000L, secret.length);
            cipher.setKey(secretIt);
            cipher.setAuthData(Transcoder.utf8().decode(key));
            byte[] plainText = split.get(i);
            byte[] cipherText = cipher.encrypt(plainText);
            shares.add(cipherText);
        }
    }

    private void restoreThresholdKeyFromInputs(List<String> keys, int threshold, byte[] secret, List<byte[]> shares) throws IonicException {
        ArrayList<byte[]> sharesIt = new ArrayList<byte[]>(shares.subList(0, keys.size()));
        shares.removeAll(sharesIt);
        byte[] salt = Transcoder.utf8().decode(Value.joinCollection("|", keys));
        ArrayList<byte[]> parts = new ArrayList<byte[]>();
        AesGcmCipher cipher = new AesGcmCipher();
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            byte[] value = Transcoder.utf8().decode(this.properties.getProperty(key));
            byte[] valuePBKDF = Value.isEmpty(value) ? new CryptoRng().rand(new byte[8]) : value;
            byte[] secretIt = CryptoUtils.pbkdf2ToBytes(valuePBKDF, salt, 10000L, secret.length);
            cipher.setKey(secretIt);
            cipher.setAuthData(Transcoder.utf8().decode(key));
            byte[] cipherText = (byte[])sharesIt.get(i);
            try {
                byte[] decrypt = cipher.decrypt(cipherText);
                if (decrypt.length == secret.length + 4) {
                    parts.add(decrypt);
                    this.logger.fine(String.format("A piece of environmental data has been recovered [%s].", key));
                    continue;
                }
                this.logger.fine(String.format("A piece of environmental data has been discarded [%s].", key));
                continue;
            }
            catch (IonicException e) {
                this.logger.warning(String.format("A piece of environmental data is missing or changed [%s].", key));
            }
        }
        if (parts.size() < threshold) {
            throw new IonicException(50001, (Throwable)new GeneralSecurityException(String.format("Unable to recover key; %d shares decrypted, %d needed.", parts.size(), threshold)));
        }
        Scheme scheme = new Scheme(keys.size(), threshold);
        byte[] secretPart = scheme.join(parts, secret.length);
        System.arraycopy(secretPart, 0, secret, 0, secretPart.length);
    }

    private void accumulateXOR(byte[] accumulator, byte[] input) {
        for (int i = 0; i < accumulator.length; ++i) {
            int n = i;
            accumulator[n] = (byte)(accumulator[n] ^ input[i]);
        }
    }
}

