/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.crypto.secretshare;

import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.crypto.CryptoUtils;
import com.ionic.sdk.crypto.secretshare.SecretShareBucket;
import com.ionic.sdk.crypto.secretshare.SecretShareData;
import com.ionic.sdk.crypto.secretshare.SecretShareGenerator;
import com.ionic.sdk.crypto.secretshare.SecretShareKey;
import com.ionic.sdk.device.DeviceUtils;
import com.ionic.sdk.error.IonicException;
import java.io.File;
import java.util.Collection;
import java.util.logging.Logger;

public class SecretSharePersistor {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final String path;
    private final SecretShareData shareData;

    public SecretSharePersistor(String path, SecretShareData shareData) {
        this.path = path;
        this.shareData = shareData;
    }

    public final String generateKey() throws IonicException {
        SecretShareKey secretShareKey;
        SecretShareGenerator generator = new SecretShareGenerator(this.shareData.getData());
        Collection<SecretShareBucket> buckets = this.shareData.getBuckets();
        for (SecretShareBucket bucket : buckets) {
            generator.addBucket(bucket);
        }
        File file = new File(this.path);
        if (file.exists()) {
            byte[] bytes = DeviceUtils.read(file);
            this.logger.info(String.format("SecretSharePersistor, resource=[%s], hash=[%s], size=[%d]", this.path, CryptoUtils.sha256ToHexString(bytes), bytes.length));
            secretShareKey = generator.recover(Transcoder.utf8().encode(bytes));
        } else {
            secretShareKey = generator.generate();
            DeviceUtils.write(file, Transcoder.utf8().decode(secretShareKey.getShares()));
        }
        return secretShareKey.getKey();
    }
}

