/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.crypto.shamir;

import com.ionic.sdk.core.codec.Transcoder;
import java.util.Random;

public final class GF256 {
    private static final byte[] LOG = Transcoder.hex().decode("ff00190132021ac64bc71b6833eedf036404e00e348d81ef4c7108c8f8691cc17dc21db5f9b9276a4de4a6729ac90978652f8a05210fe12412f082453593da8e968fdbbd36d0ce94135cd2f14046833866ddfd30bf068b62b325e298228891107e6e48c3a3b61e423a6b2854fa853dba2b790a159b9f5eca4ed4ace5f373a757af58a850f4ead6744faee9d5e7e6ade82cd7757aeb160bf559cb5fb09ca951a07f0cf66f17c449ecd8431f2da4767bb7ccbb3e5afb60b1863b52a16caa55299d97b2879061bedcfcbc95cfcd373f5bd15339843c41a26d47142a9e5d56f2d3ab441192d923202e89b47cb8267799e3a5674aeddec531fe180d638c80c0f77007");
    private static final byte[] EXP = Transcoder.hex().decode("0103050f113355ff1a2e7296a1f813355fe13848d87395a4f702060a1e2266aae5345ce43759eb266abed97090abe63153f5040c143c44cc4fd168b8d36eb2cd4cd467a9e03b4dd762a6f10818287888839eb9d06bbddc7f8198b3ce49db769ab5c457f9103050f00b1d2769bbd661a3fe192b7d8792adec2f7193aee92060a0fb163a4ed26db7c25de73256fa153f41c35ee23d47c940c05bed2c749cbfda759fbad564acef2a7e829dbcdf7a8e89809bb6c158e82365afea256fb1c843c554fc1f2163a5f407091b2d7799b0cb46ca45cf4ade798b8691a8e33e42c651f30e12365aee297b8d8c8f8a8594a7f20d17394bdd7c8497a2fd1c246cb4c752f60103050f113355ff1a2e7296a1f813355fe13848d87395a4f702060a1e2266aae5345ce43759eb266abed97090abe63153f5040c143c44cc4fd168b8d36eb2cd4cd467a9e03b4dd762a6f10818287888839eb9d06bbddc7f8198b3ce49db769ab5c457f9103050f00b1d2769bbd661a3fe192b7d8792adec2f7193aee92060a0fb163a4ed26db7c25de73256fa153f41c35ee23d47c940c05bed2c749cbfda759fbad564acef2a7e829dbcdf7a8e89809bb6c158e82365afea256fb1c843c554fc1f2163a5f407091b2d7799b0cb46ca45cf4ade798b8691a8e33e42c651f30e12365aee297b8d8c8f8a8594a7f20d17394bdd7c8497a2fd1c246cb4c752f60103");

    private GF256() {
    }

    private static byte add(byte a, byte b) {
        return (byte)(a ^ b);
    }

    private static byte sub(byte a, byte b) {
        return GF256.add(a, b);
    }

    private static byte mul(byte a, byte b) {
        if (a == 0 || b == 0) {
            return 0;
        }
        byte logA = LOG[GF256.toUnsignedInt(a)];
        byte logB = LOG[GF256.toUnsignedInt(b)];
        return EXP[GF256.toUnsignedInt(logA) + GF256.toUnsignedInt(logB)];
    }

    private static byte div(byte a, byte b) {
        byte logB = LOG[GF256.toUnsignedInt(b)];
        return GF256.mul(a, EXP[LOG.length - 1 - GF256.toUnsignedInt(logB)]);
    }

    public static byte eval(byte[] p, byte x) {
        byte result = 0;
        for (int i = p.length - 1; i >= 0; --i) {
            byte mul = GF256.mul(result, x);
            result = GF256.add(mul, p[i]);
        }
        return result;
    }

    private static int degree(byte[] p) {
        for (int i = p.length - 1; i >= 1; --i) {
            if (p[i] == 0) continue;
            return i;
        }
        return 0;
    }

    public static byte[] generate(Random random, int degree, byte x) {
        byte[] p = new byte[degree + 1];
        do {
            random.nextBytes(p);
        } while (GF256.degree(p) != degree);
        p[0] = x;
        return p;
    }

    public static byte interpolate(byte[][] points) {
        boolean x = false;
        byte y = 0;
        for (int i = 0; i < points.length; ++i) {
            byte aX = points[i][0];
            byte aY = points[i][1];
            byte li = 1;
            for (int j = 0; j < points.length; ++j) {
                byte bX = points[j][0];
                if (i == j) continue;
                li = GF256.mul(li, GF256.div(GF256.sub((byte)0, bX), GF256.sub(aX, bX)));
            }
            y = GF256.add(y, GF256.mul(li, aY));
        }
        return y;
    }

    private static int toUnsignedInt(byte x) {
        return x & 0xFF;
    }
}

