/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.crypto.shamir;

import com.ionic.sdk.crypto.shamir.GF256;
import com.ionic.sdk.error.IonicException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Scheme {
    private final int n;
    private final int k;
    private final SecureRandom random;
    private static final int CRYPTOPP_OFFSET = 4;
    private static final int MAX_N = 255;

    public Scheme(int n, int k) throws IonicException {
        boolean invalid;
        boolean bl = invalid = k < 1 || n < k || n > 255;
        if (invalid) {
            throw new IonicException(40005, (Throwable)new IllegalArgumentException(String.format("N = %d, K = %d", n, k)));
        }
        this.n = n;
        this.k = k;
        this.random = new SecureRandom();
    }

    public List<byte[]> split(byte[] secret) {
        byte[][] values = new byte[this.n][secret.length];
        for (int i = 0; i < secret.length; ++i) {
            byte[] p = GF256.generate(this.random, this.k - 1, secret[i]);
            for (int x = 1; x <= this.n; ++x) {
                values[x - 1][i] = GF256.eval(p, (byte)x);
            }
        }
        ArrayList<byte[]> parts = new ArrayList<byte[]>(this.n);
        for (int i = 0; i < values.length; ++i) {
            byte[] value = values[i];
            byte[] valueWrapped = new byte[value.length + 4];
            ByteBuffer.wrap(valueWrapped, 0, 4).putInt(i + 1);
            System.arraycopy(value, 0, valueWrapped, 4, value.length);
            parts.add(valueWrapped);
        }
        return Collections.unmodifiableList(parts);
    }

    public byte[] join(Collection<byte[]> parts, int length) {
        byte[] secret = new byte[length];
        for (int i = 0; i < secret.length; ++i) {
            byte[][] points = new byte[parts.size()][2];
            int j = 0;
            for (byte[] value : parts) {
                int channel = ByteBuffer.wrap(value, 0, 4).getInt();
                byte[] valueUnwrapped = new byte[value.length - 4];
                System.arraycopy(value, 4, valueUnwrapped, 0, valueUnwrapped.length);
                points[j][0] = Integer.valueOf(channel).byteValue();
                points[j][1] = valueUnwrapped[i];
                ++j;
            }
            secret[i] = GF256.interpolate(points);
        }
        return secret;
    }
}

