/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.device;

import com.ionic.sdk.core.io.Stream;
import com.ionic.sdk.core.res.Resource;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

public final class DeviceUtils {
    private DeviceUtils() {
    }

    public static int readByte(InputStream is) throws IonicException {
        try {
            return is.read();
        }
        catch (IOException e) {
            throw new IonicException(80009, (Throwable)e);
        }
    }

    public static byte[] read(URL url) throws IonicException {
        try {
            return Stream.read(url);
        }
        catch (IOException e) {
            throw new IonicException(40013, (Throwable)e);
        }
    }

    public static byte[] read(InputStream is) throws IonicException {
        try {
            return Stream.read(is);
        }
        catch (IOException e) {
            throw new IonicException(40013, (Throwable)e);
        }
    }

    public static byte[] readSlow(File file) throws IonicException {
        try {
            return Stream.readSlow(file);
        }
        catch (IOException e) {
            throw new IonicException(40013, (Throwable)e);
        }
    }

    public static byte[] read(File file) throws IonicException {
        try {
            return Stream.read(file);
        }
        catch (IOException e) {
            throw new IonicException(40013, (Throwable)e);
        }
    }

    public static void write(File file, byte[] bytes) throws IonicException {
        try {
            Stream.write(file, bytes);
        }
        catch (IOException e) {
            throw new IonicException(40013, (Throwable)e);
        }
    }

    public static void write(OutputStream os, byte[] bytes) throws IonicException {
        try {
            Stream.write(os, bytes);
        }
        catch (IOException e) {
            throw new IonicException(40013, (Throwable)e);
        }
    }

    public static File toFile(String resource) throws IonicException {
        URL url = Resource.resolve(resource);
        SdkData.checkTrue(url != null, 40023, URL.class.getName());
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IonicException(40023, (Throwable)e);
        }
    }

    public static URL toUrl(String url) throws IonicException {
        try {
            return new URL(url);
        }
        catch (NullPointerException e) {
            throw new IonicException(40021, (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new IonicException(40005, (Throwable)e);
        }
    }
}

