/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.device.create;

import com.ionic.sdk.agent.Agent;
import com.ionic.sdk.agent.config.AgentConfig;
import com.ionic.sdk.agent.request.createdevice.CreateDeviceResponse;
import com.ionic.sdk.agent.transaction.AgentTransactionUtil;
import com.ionic.sdk.cipher.rsa.model.RsaKeyHolder;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.io.Stream;
import com.ionic.sdk.device.create.EnrollIonicAuth;
import com.ionic.sdk.device.create.EnrollSAML;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.httpclient.HttpClientDefault;
import com.ionic.sdk.httpclient.HttpRequest;
import com.ionic.sdk.httpclient.HttpResponse;
import com.ionic.sdk.json.JsonSource;
import com.ionic.sdk.json.JsonU;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;

public class EnrollIdentitySources {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final URL url;
    private final Agent agent;
    private final RsaKeyHolder rsaKeyHolder;
    private static final String IDENTITY_SOURCES = "identitySources";
    private static final String IDC = "IDC";
    private static final String SAML = "SAML";
    private static final String URI = "uri";
    private static final String IS_DEFAULT = "isDefault";

    public EnrollIdentitySources(String url, Agent agent, RsaKeyHolder rsaKeyHolder) throws IonicException {
        this.url = AgentTransactionUtil.getProfileUrl(url);
        this.agent = agent;
        this.rsaKeyHolder = rsaKeyHolder;
    }

    public CreateDeviceResponse enroll(String user, String pass, String deviceProfileName) throws IonicException {
        try {
            HttpClientDefault httpClient = new HttpClientDefault(new AgentConfig(), this.url.getProtocol());
            HttpRequest httpRequest = new HttpRequest(this.url, "GET", this.url.getFile());
            HttpResponse httpResponse = httpClient.execute(httpRequest);
            SdkData.checkTrue(AgentTransactionUtil.isHttpSuccessCode(httpResponse.getStatusCode()), 40009);
            this.logger.info(httpResponse.getHttpHeaders().getHeaderValue("Content-Type"));
            byte[] entity = Stream.read(httpResponse.getEntity());
            JsonObject jsonEntity = JsonU.getJsonObject(Transcoder.utf8().encode(entity));
            this.logger.finest(JsonU.toJson(jsonEntity, true));
            JsonObject jsonIS = JsonSource.getJsonObject(jsonEntity, IDENTITY_SOURCES);
            if (JsonValue.ValueType.ARRAY.equals((Object)JsonSource.getValueType(jsonIS, IDC))) {
                JsonArray jsonIonicAuth = JsonSource.getJsonArray(jsonIS, IDC);
                Iterator<JsonValue> iterator = JsonSource.getIterator(jsonIonicAuth);
                while (iterator.hasNext()) {
                    JsonObject jsonMethod = (JsonObject)iterator.next();
                    boolean isDefault = JsonSource.getBoolean(jsonMethod, IS_DEFAULT);
                    if (!isDefault) continue;
                    String uri = JsonSource.getString(jsonMethod, URI);
                    EnrollIonicAuth enrollIonicAuth = new EnrollIonicAuth(uri, this.agent, this.rsaKeyHolder);
                    return enrollIonicAuth.enroll(user, pass, deviceProfileName);
                }
                throw new IonicException(40004, IS_DEFAULT);
            }
            if (JsonValue.ValueType.ARRAY.equals((Object)JsonSource.getValueType(jsonIS, SAML))) {
                JsonArray jsonSAML = JsonSource.getJsonArray(jsonIS, SAML);
                Iterator<JsonValue> iterator = JsonSource.getIterator(jsonSAML);
                while (iterator.hasNext()) {
                    JsonObject jsonMethod = (JsonObject)iterator.next();
                    boolean isDefault = JsonSource.getBoolean(jsonMethod, IS_DEFAULT);
                    if (!isDefault) continue;
                    String uri = JsonSource.getString(jsonMethod, URI);
                    EnrollSAML enrollSAML = new EnrollSAML(uri, this.agent, this.rsaKeyHolder);
                    return enrollSAML.enroll(user, pass, deviceProfileName);
                }
                throw new IonicException(40004, IS_DEFAULT);
            }
            throw new IonicException(40018);
        }
        catch (IOException e) {
            throw new IonicException(40009, (Throwable)e);
        }
    }
}

