/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.device.create;

import com.ionic.sdk.agent.Agent;
import com.ionic.sdk.agent.config.AgentConfig;
import com.ionic.sdk.agent.request.createdevice.CreateDeviceRequest;
import com.ionic.sdk.agent.request.createdevice.CreateDeviceResponse;
import com.ionic.sdk.agent.transaction.AgentTransactionUtil;
import com.ionic.sdk.cipher.rsa.model.RsaKeyHolder;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.io.Stream;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.error.SdkError;
import com.ionic.sdk.httpclient.HttpClient;
import com.ionic.sdk.httpclient.HttpClientDefault;
import com.ionic.sdk.httpclient.HttpHeader;
import com.ionic.sdk.httpclient.HttpHeaders;
import com.ionic.sdk.httpclient.HttpRequest;
import com.ionic.sdk.httpclient.HttpResponse;
import com.ionic.sdk.httpclient.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;

public class EnrollIonicAuth {
    private final URL url;
    private final Agent agent;
    private final RsaKeyHolder rsaKeyHolder;

    public EnrollIonicAuth(String url, Agent agent, RsaKeyHolder rsaKeyHolder) throws IonicException {
        this.url = AgentTransactionUtil.getProfileUrl(url);
        this.agent = agent;
        this.rsaKeyHolder = rsaKeyHolder;
    }

    public CreateDeviceResponse enroll(String user, String pass, String deviceProfileName) throws IonicException {
        try {
            HttpClientDefault httpClient = new HttpClientDefault(new AgentConfig(), this.url.getProtocol());
            HttpResponse httpResponse1 = this.submitAuthRequest(httpClient, user, pass);
            HttpResponse httpResponse2 = this.retrievePubkey(httpClient, httpResponse1);
            return this.createDevice(httpResponse1, httpResponse2, deviceProfileName);
        }
        catch (IOException e) {
            throw new IonicException(40009, (Throwable)e);
        }
    }

    private HttpResponse submitAuthRequest(HttpClient httpClient, String user, String pass) throws IOException, IonicException {
        byte[] entity = Transcoder.utf8().decode(String.format("username=%s&password=%s", HttpUtils.urlEncode(user), HttpUtils.urlEncode(pass)));
        HttpRequest httpRequest = new HttpRequest(this.url, "POST", this.url.getFile(), new HttpHeaders(new HttpHeader[0]), new ByteArrayInputStream(entity));
        HttpResponse httpResponse = httpClient.execute(httpRequest);
        SdkData.checkTrue(AgentTransactionUtil.isHttpSuccessCode(httpResponse.getStatusCode()), 40009);
        return httpResponse;
    }

    private HttpResponse retrievePubkey(HttpClient httpClient, HttpResponse httpResponse3) throws IOException, IonicException {
        String urlPubkey = httpResponse3.getHttpHeaders().getHeaderValue("X-Ionic-Reg-Pubkey-Url");
        URL url4 = AgentTransactionUtil.getProfileUrl(urlPubkey);
        HttpRequest httpRequest = new HttpRequest(url4, "GET", url4.getFile());
        HttpResponse httpResponse = httpClient.execute(httpRequest);
        SdkData.checkTrue(AgentTransactionUtil.isHttpSuccessCode(httpResponse.getStatusCode()), 40009, SdkError.getErrorString(40009));
        return httpResponse;
    }

    private CreateDeviceResponse createDevice(HttpResponse httpResponseAuth, HttpResponse httpResponsePubkey, String deviceProfileName) throws IOException, IonicException {
        String server = httpResponseAuth.getHttpHeaders().getHeaderValue("X-Ionic-Reg-Ionic-Url");
        String keyspace = httpResponseAuth.getHttpHeaders().getHeaderValue("X-Ionic-Reg-Enrollment-Tag");
        String token = httpResponseAuth.getHttpHeaders().getHeaderValue("X-Ionic-Reg-Stoken");
        String uid = httpResponseAuth.getHttpHeaders().getHeaderValue("X-Ionic-Reg-Uidauth");
        byte[] pubkeyBytes = Stream.read(httpResponsePubkey.getEntity());
        String pubkeyText = Transcoder.utf8().encode(pubkeyBytes).trim();
        this.agent.initializeWithoutProfiles();
        CreateDeviceRequest request = new CreateDeviceRequest(deviceProfileName, server, keyspace, token, uid, pubkeyText);
        request.setRsaKeyHolder(this.rsaKeyHolder);
        return this.agent.createDevice(request);
    }

    private static class Payload {
        private static final String REQUEST_AUTH = "username=%s&password=%s";

        private Payload() {
        }
    }

    private static class Header {
        private static final String X_IONIC_REG_ENROLLMENT_TAG = "X-Ionic-Reg-Enrollment-Tag";
        private static final String X_IONIC_REG_IONIC_URL = "X-Ionic-Reg-Ionic-Url";
        private static final String X_IONIC_REG_PUBKEY_URL = "X-Ionic-Reg-Pubkey-Url";
        private static final String X_IONIC_REG_STOKEN = "X-Ionic-Reg-Stoken";
        private static final String X_IONIC_REG_UIDAUTH = "X-Ionic-Reg-Uidauth";

        private Header() {
        }
    }
}

