/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.device.create;

import com.ionic.sdk.agent.Agent;
import com.ionic.sdk.agent.config.AgentConfig;
import com.ionic.sdk.agent.request.createdevice.CreateDeviceRequest;
import com.ionic.sdk.agent.request.createdevice.CreateDeviceResponse;
import com.ionic.sdk.agent.transaction.AgentTransactionUtil;
import com.ionic.sdk.cipher.rsa.model.RsaKeyHolder;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.io.Stream;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.error.SdkError;
import com.ionic.sdk.httpclient.HttpClient;
import com.ionic.sdk.httpclient.HttpClientDefault;
import com.ionic.sdk.httpclient.HttpHeader;
import com.ionic.sdk.httpclient.HttpHeaders;
import com.ionic.sdk.httpclient.HttpRequest;
import com.ionic.sdk.httpclient.HttpResponse;
import com.ionic.sdk.httpclient.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;

public final class EnrollSAML {
    private final URL url;
    private final Agent agent;
    private final RsaKeyHolder rsaKeyHolder;

    public EnrollSAML(String url) throws IonicException {
        this(url, new Agent(), null);
    }

    public EnrollSAML(String url, Agent agent) throws IonicException {
        this(url, agent, null);
    }

    public EnrollSAML(String url, Agent agent, RsaKeyHolder rsaKeyHolder) throws IonicException {
        this.url = AgentTransactionUtil.getProfileUrl(url);
        this.agent = agent;
        this.rsaKeyHolder = rsaKeyHolder;
    }

    public CreateDeviceResponse enroll(String user, String pass, String deviceProfileName) throws IonicException {
        try {
            HttpClientDefault httpClient = new HttpClientDefault(new AgentConfig(), this.url.getProtocol());
            HttpResponse httpResponse1 = this.initiateTransaction(httpClient, this.url);
            HttpResponse httpResponse2 = this.submitSamlRequest(httpClient, httpResponse1, user, pass);
            HttpResponse httpResponse3 = this.submitSamlResponse(httpClient, httpResponse1, httpResponse2);
            HttpResponse httpResponse4 = this.retrievePubkey(httpClient, httpResponse3);
            return this.createDevice(httpResponse3, httpResponse4, deviceProfileName);
        }
        catch (IOException e) {
            throw new IonicException(40009, (Throwable)e);
        }
    }

    private HttpResponse initiateTransaction(HttpClient httpClient, URL url) throws IOException, IonicException {
        HttpRequest httpRequest = new HttpRequest(url, "GET", url.getFile());
        HttpResponse httpResponse = httpClient.execute(httpRequest);
        SdkData.checkTrue(AgentTransactionUtil.isHttpSuccessCode(httpResponse.getStatusCode()), 40009, SdkError.getErrorString(40009));
        return httpResponse;
    }

    private HttpResponse submitSamlRequest(HttpClient httpClient, HttpResponse httpResponse1, String user, String pass) throws IOException, IonicException {
        String samlRedirect = httpResponse1.getHttpHeaders().getHeaderValue("X-Saml-Redirect");
        String samlRequest = httpResponse1.getHttpHeaders().getHeaderValue("X-Saml-Request");
        SdkData.checkTrue(samlRedirect != null, 40005, SdkError.getErrorString(40005));
        SdkData.checkTrue(samlRequest != null, 40005, SdkError.getErrorString(40005));
        URL url2 = AgentTransactionUtil.getProfileUrl(samlRedirect);
        byte[] entity = Transcoder.utf8().decode(String.format("user=%s&password=%s&SAMLRequest=%s", HttpUtils.urlEncode(user), HttpUtils.urlEncode(pass), HttpUtils.urlEncode(samlRequest)));
        HttpRequest httpRequest = new HttpRequest(url2, "POST", url2.getFile(), new HttpHeaders(new HttpHeader[0]), new ByteArrayInputStream(entity));
        HttpResponse httpResponse = httpClient.execute(httpRequest);
        SdkData.checkTrue(AgentTransactionUtil.isHttpSuccessCode(httpResponse.getStatusCode()), 40009, SdkError.getErrorString(40009));
        return httpResponse;
    }

    private HttpResponse submitSamlResponse(HttpClient httpClient, HttpResponse httpResponse1, HttpResponse httpResponse2) throws IOException, IonicException {
        String samlRelayState1 = httpResponse1.getHttpHeaders().getHeaderValue("X-Saml-Relay-State");
        URL url3 = AgentTransactionUtil.getProfileUrl(samlRelayState1);
        String samlResponse2 = httpResponse2.getHttpHeaders().getHeaderValue("X-Saml-Response");
        SdkData.checkTrue(samlResponse2 != null, 40009, SdkError.getErrorString(40009));
        byte[] entity = Transcoder.utf8().decode(String.format("SAMLResponse=%s", HttpUtils.urlEncode(samlResponse2)));
        HttpRequest httpRequest = new HttpRequest(url3, "POST", url3.getFile(), new HttpHeaders(new HttpHeader[0]), new ByteArrayInputStream(entity));
        HttpResponse httpResponse = httpClient.execute(httpRequest);
        SdkData.checkTrue(AgentTransactionUtil.isHttpSuccessCode(httpResponse.getStatusCode()), 40009, SdkError.getErrorString(40009));
        return httpResponse;
    }

    private HttpResponse retrievePubkey(HttpClient httpClient, HttpResponse httpResponse3) throws IOException, IonicException {
        String urlPubkey = httpResponse3.getHttpHeaders().getHeaderValue("X-Ionic-Reg-Pubkey-Url");
        URL url4 = AgentTransactionUtil.getProfileUrl(urlPubkey);
        HttpRequest httpRequest = new HttpRequest(url4, "GET", url4.getFile());
        HttpResponse httpResponse = httpClient.execute(httpRequest);
        SdkData.checkTrue(AgentTransactionUtil.isHttpSuccessCode(httpResponse.getStatusCode()), 40009, SdkError.getErrorString(40009));
        return httpResponse;
    }

    private CreateDeviceResponse createDevice(HttpResponse httpResponse3, HttpResponse httpResponse4, String deviceProfileName) throws IOException, IonicException {
        String server = httpResponse3.getHttpHeaders().getHeaderValue("X-Ionic-Reg-Ionic-Url");
        String keyspace = httpResponse3.getHttpHeaders().getHeaderValue("X-Ionic-Reg-Enrollment-Tag");
        String token = httpResponse3.getHttpHeaders().getHeaderValue("X-Ionic-Reg-Stoken");
        String uid = httpResponse3.getHttpHeaders().getHeaderValue("X-Ionic-Reg-Uidauth");
        byte[] pubkeyBytes = Stream.read(httpResponse4.getEntity());
        String pubkeyText = Transcoder.utf8().encode(pubkeyBytes).trim();
        this.agent.initializeWithoutProfiles();
        CreateDeviceRequest request = new CreateDeviceRequest(deviceProfileName, server, keyspace, token, uid, pubkeyText);
        request.setRsaKeyHolder(this.rsaKeyHolder);
        return this.agent.createDevice(request);
    }

    private static class Payload {
        private static final String SAML_REQUEST = "user=%s&password=%s&SAMLRequest=%s";
        private static final String SAML_RESPONSE = "SAMLResponse=%s";

        private Payload() {
        }
    }

    private static class Header {
        private static final String X_IONIC_REG_ENROLLMENT_TAG = "X-Ionic-Reg-Enrollment-Tag";
        private static final String X_IONIC_REG_IONIC_URL = "X-Ionic-Reg-Ionic-Url";
        private static final String X_IONIC_REG_PUBKEY_URL = "X-Ionic-Reg-Pubkey-Url";
        private static final String X_IONIC_REG_STOKEN = "X-Ionic-Reg-Stoken";
        private static final String X_IONIC_REG_UIDAUTH = "X-Ionic-Reg-Uidauth";
        private static final String X_SAML_REDIRECT = "X-Saml-Redirect";
        private static final String X_SAML_RELAY_STATE = "X-Saml-Relay-State";
        private static final String X_SAML_REQUEST = "X-Saml-Request";
        private static final String X_SAML_RESPONSE = "X-Saml-Response";

        private Header() {
        }
    }
}

