/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.device.profile;

import com.ionic.sdk.error.IonicException;
import java.io.Serializable;
import java.security.InvalidKeyException;

public class DeviceProfile
implements Serializable {
    private String deviceName = "";
    private String serverName = "";
    private String deviceProfileId = "";
    private long timestamp;
    private byte[] aesCdIdcProfileKey;
    private byte[] aesCdEiProfileKey;
    private static final String REGEX_TOKEN_DOT = "\\.";
    private static final long serialVersionUID = -8004857920029153448L;

    public DeviceProfile() {
        this.timestamp = 0L;
    }

    public DeviceProfile(DeviceProfile profile) {
        this(profile.getName(), profile.getCreationTimestampSecs(), profile.getDeviceId(), profile.getServer(), profile.getAesCdIdcProfileKey(), profile.getAesCdEiProfileKey());
    }

    public DeviceProfile(String name, long creationTimestamp, String deviceId, String server, byte[] aesCdIdcKey, byte[] aesCdEiKey) {
        this.deviceName = name;
        this.timestamp = creationTimestamp;
        this.deviceProfileId = deviceId;
        this.serverName = server;
        this.aesCdIdcProfileKey = aesCdIdcKey == null ? null : (byte[])aesCdIdcKey.clone();
        this.aesCdEiProfileKey = aesCdEiKey == null ? null : (byte[])aesCdEiKey.clone();
    }

    public final boolean isLoaded() {
        return !this.deviceProfileId.isEmpty() && this.aesCdIdcProfileKey.length != 0 && this.aesCdEiProfileKey.length != 0;
    }

    public final boolean isValid() throws IonicException {
        if (this.aesCdIdcProfileKey == null || this.aesCdEiProfileKey == null) {
            throw new IonicException(40030, (Throwable)new InvalidKeyException((String)null));
        }
        if (this.aesCdIdcProfileKey.length != 32) {
            throw new IonicException(40030, (Throwable)new InvalidKeyException(Integer.toString(this.aesCdIdcProfileKey.length)));
        }
        if (this.aesCdEiProfileKey.length != 32) {
            throw new IonicException(40030, (Throwable)new InvalidKeyException(Integer.toString(this.aesCdEiProfileKey.length)));
        }
        return true;
    }

    public final String getName() {
        return this.deviceName;
    }

    public final void setName(String name) {
        this.deviceName = name;
    }

    public final long getCreationTimestampSecs() {
        return this.timestamp;
    }

    public final void setCreationTimestampSecs(long timestamp) {
        this.timestamp = timestamp;
    }

    public final String getServer() {
        return this.serverName;
    }

    public final void setServer(String server) {
        this.serverName = server;
    }

    public final String getDeviceId() {
        return this.deviceProfileId;
    }

    public final void setDeviceId(String deviceId) {
        this.deviceProfileId = deviceId;
    }

    public final byte[] getAesCdIdcProfileKey() {
        return this.aesCdIdcProfileKey == null ? null : (byte[])this.aesCdIdcProfileKey.clone();
    }

    public final void setAesCdIdcProfileKey(byte[] keyBytes) {
        if (keyBytes != null) {
            this.aesCdIdcProfileKey = (byte[])keyBytes.clone();
        }
    }

    public final byte[] getAesCdEiProfileKey() {
        return this.aesCdEiProfileKey == null ? null : (byte[])this.aesCdEiProfileKey.clone();
    }

    public final void setAesCdEiProfileKey(byte[] keyBytes) {
        if (keyBytes != null) {
            this.aesCdEiProfileKey = (byte[])keyBytes.clone();
        }
    }

    public final String getKeySpace() {
        return this.deviceProfileId == null ? "" : this.deviceProfileId.split(REGEX_TOKEN_DOT, -1)[0];
    }
}

