/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.device.profile.persistor;

import com.ionic.sdk.cipher.CipherAbstract;
import com.ionic.sdk.cipher.aes.AesGcmCipher;
import com.ionic.sdk.device.profile.persistor.DeviceProfilePersistorBase;
import com.ionic.sdk.error.IonicException;
import java.io.InputStream;
import java.net.URL;

public class DeviceProfilePersistorAesGcm
extends DeviceProfilePersistorBase {
    private byte[] mAuthData;
    private byte[] mKeyData;
    private final AesGcmCipher cipherCast = (AesGcmCipher)this.getCipher();
    public static final String FORMAT_AESGCM = "aesgcm";

    public DeviceProfilePersistorAesGcm(String filePath) throws IonicException {
        super(filePath, (CipherAbstract)new AesGcmCipher());
    }

    public DeviceProfilePersistorAesGcm(URL url) throws IonicException {
        super(url, (CipherAbstract)new AesGcmCipher());
    }

    public DeviceProfilePersistorAesGcm(InputStream inputStream) throws IonicException {
        super(inputStream, (CipherAbstract)new AesGcmCipher());
    }

    public DeviceProfilePersistorAesGcm() throws IonicException {
        super(new AesGcmCipher());
    }

    public final byte[] getAuthData() {
        return (byte[])this.mAuthData.clone();
    }

    public final void setAuthData(byte[] authData) {
        this.mAuthData = (byte[])authData.clone();
        this.cipherCast.setAuthData(this.mAuthData);
    }

    public final byte[] getKey() {
        return (byte[])this.mKeyData.clone();
    }

    public final void setKey(byte[] key) {
        this.mKeyData = (byte[])key.clone();
        this.cipherCast.setKey(this.mKeyData);
    }

    @Override
    protected final String getFormat() {
        return FORMAT_AESGCM;
    }
}

