/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.device.profile.persistor;

import com.ionic.sdk.cipher.CipherAbstract;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.datastructures.Tuple;
import com.ionic.sdk.core.io.Stream;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.crypto.CryptoUtils;
import com.ionic.sdk.device.DeviceUtils;
import com.ionic.sdk.device.profile.DeviceProfile;
import com.ionic.sdk.device.profile.persistor.DeviceProfileSerializer;
import com.ionic.sdk.device.profile.persistor.ProfilePersistor;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import com.ionic.sdk.json.JsonTarget;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public abstract class DeviceProfilePersistorBase
implements ProfilePersistor {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private ArrayList<DeviceProfile> mProfiles;
    private String activeDeviceProfileId = "";
    private final CipherAbstract mCipher;
    private String mFilePath = "";
    private URL mUrl;
    private String version;
    private String extra;
    private byte[] inputStreamBytes;
    private boolean shouldUpdateProfiles = true;
    public static final String VERSION_1_0 = "1.0";
    public static final String VERSION_1_1 = "1.1";
    public static final String EXTRA = "extra";
    public static final String FILE_TYPE_ID = "fileTypeId";
    public static final String FILE_TYPE_DEVICE_PROFILES = "ionic-device-profiles";
    public static final String FORMAT = "format";
    public static final String SALT = "salt";
    public static final String VERSION = "version";

    public DeviceProfilePersistorBase(String filePath, CipherAbstract cipher) {
        this.mFilePath = filePath;
        this.mUrl = null;
        this.inputStreamBytes = null;
        this.mCipher = cipher;
    }

    public DeviceProfilePersistorBase(URL url, CipherAbstract cipher) {
        this.mFilePath = null;
        this.mUrl = url;
        this.inputStreamBytes = null;
        this.mCipher = cipher;
    }

    public DeviceProfilePersistorBase(InputStream inputStream, CipherAbstract cipher) throws IonicException {
        this.mFilePath = null;
        this.mUrl = null;
        SdkData.checkTrue(inputStream != null, 40021);
        this.inputStreamBytes = DeviceUtils.read(inputStream);
        this.mCipher = cipher;
    }

    public DeviceProfilePersistorBase(CipherAbstract cipher) {
        this.mCipher = cipher;
    }

    protected final CipherAbstract getCipher() {
        return this.mCipher;
    }

    protected abstract String getFormat();

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    protected void setExtra(String extra) {
        this.extra = extra;
    }

    protected void initializeCipher(String json) throws IonicException {
    }

    public final void setFilePath(String path) throws IonicException {
        if (path == null) {
            throw new IonicException(40021);
        }
        if (this.mFilePath == null || !this.mFilePath.equals(path)) {
            this.mFilePath = path;
            this.shouldUpdateProfiles = true;
        }
    }

    public final String getFilePath() {
        return this.mFilePath;
    }

    @Override
    public List<DeviceProfile> loadAllProfiles(String[] activeProfile) throws IonicException {
        File f = Value.isEmpty(this.mFilePath) ? null : new File(this.mFilePath);
        SdkData.checkTrue(f == null || f.exists(), 40023);
        SdkData.checkTrue(f != null || this.mUrl != null || this.inputStreamBytes != null, 40023);
        if (this.shouldUpdateProfiles) {
            Tuple<List<DeviceProfile>, String> profiles = f != null ? this.loadAllProfilesFromFile(this.mFilePath) : (this.mUrl != null ? this.loadAllProfilesFromURL(this.mUrl) : (this.inputStreamBytes != null ? this.loadAllProfilesFromJson(InputStream.class.getSimpleName(), this.inputStreamBytes, this.mCipher) : null));
            SdkData.checkNotNull(profiles, DeviceProfile.class.getName());
            this.mProfiles = new ArrayList(profiles.first());
            this.activeDeviceProfileId = profiles.second();
            this.shouldUpdateProfiles = false;
        }
        if (activeProfile != null && activeProfile.length >= 1) {
            activeProfile[0] = this.activeDeviceProfileId;
        }
        return new ArrayList<DeviceProfile>(this.mProfiles);
    }

    @Override
    public void saveAllProfiles(List<DeviceProfile> profiles, String activeProfile) throws IonicException {
        this.mProfiles = new ArrayList<DeviceProfile>(profiles);
        this.activeDeviceProfileId = activeProfile;
        this.saveAllProfilesToFile(this.mProfiles, this.activeDeviceProfileId, this.mFilePath, this.mCipher);
        this.inputStreamBytes = null;
    }

    private void saveAllProfilesToFile(List<DeviceProfile> profiles, String activeProfile, String filePath, CipherAbstract cipher) throws IonicException {
        SdkData.checkTrue(!Value.isEmpty(filePath), 40013);
        File folderParent = new File(filePath).getParentFile();
        File folder = folderParent == null ? new File(System.getProperty("user.dir")) : folderParent;
        SdkData.checkTrue(folder.exists() || folder.mkdirs(), 40013);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (VERSION_1_1.equals(this.version)) {
            String json = this.createPersistor11JsonHeader();
            DeviceUtils.write(os, Transcoder.utf8().decode(json));
            DeviceUtils.write(os, Transcoder.utf8().decode("\r\n\r\n"));
            this.initializeCipher(json);
        } else {
            this.initializeCipher(null);
        }
        DeviceUtils.write(os, DeviceProfilePersistorBase.saveAllProfilesToJson(profiles, activeProfile, cipher));
        Stream.writeToDisk(filePath, os.toByteArray());
    }

    private String createPersistor11JsonHeader() throws IonicException {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        JsonTarget.addNotNull(objectBuilder, EXTRA, (JsonValue)JsonIO.readObjectNotNull(Transcoder.utf8().decode(this.extra)));
        JsonTarget.addNotNull(objectBuilder, FILE_TYPE_ID, FILE_TYPE_DEVICE_PROFILES);
        JsonTarget.addNotNull(objectBuilder, FORMAT, this.getFormat());
        JsonTarget.addNotNull(objectBuilder, VERSION, VERSION_1_1);
        return JsonIO.write(objectBuilder.build(), false);
    }

    protected static byte[] saveAllProfilesToJson(List<DeviceProfile> profiles, String activeProfile, CipherAbstract cipher) throws IonicException {
        JsonObjectBuilder devicePersistor = Json.createObjectBuilder();
        JsonTarget.addNotNull(devicePersistor, "activeDeviceId", activeProfile);
        JsonArrayBuilder deviceProfiles = Json.createArrayBuilder();
        for (DeviceProfile profile : profiles) {
            String keyHexIDC = CryptoUtils.binToHex(profile.getAesCdIdcProfileKey());
            String keyHexEI = CryptoUtils.binToHex(profile.getAesCdEiProfileKey());
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            JsonTarget.addNotNull(objectBuilder, "name", profile.getName());
            JsonTarget.addNotNull(objectBuilder, "deviceId", profile.getDeviceId());
            JsonTarget.addNotNull(objectBuilder, "server", profile.getServer());
            JsonTarget.addNotNull(objectBuilder, "aesCdIdcKey", keyHexIDC);
            JsonTarget.addNotNull(objectBuilder, "aesCdEiKey", keyHexEI);
            JsonTarget.add(objectBuilder, "creationTimestamp", profile.getCreationTimestampSecs());
            JsonTarget.addNotNull(deviceProfiles, (JsonValue)objectBuilder.build());
        }
        JsonTarget.addNotNull(devicePersistor, "profiles", (JsonValue)deviceProfiles.build());
        JsonObject jobject = devicePersistor.build();
        return cipher.encrypt(Transcoder.utf8().decode(JsonIO.write(jobject, false)));
    }

    private Tuple<List<DeviceProfile>, String> loadAllProfilesFromFile(String filePath) throws IonicException {
        byte[] cipherText = Stream.loadFileIntoMemory(filePath);
        return this.loadAllProfilesFromJson(filePath, cipherText, this.mCipher);
    }

    private Tuple<List<DeviceProfile>, String> loadAllProfilesFromURL(URL url) throws IonicException {
        byte[] cipherText = DeviceUtils.read(url);
        return this.loadAllProfilesFromJson(url.toExternalForm(), cipherText, this.mCipher);
    }

    protected Tuple<List<DeviceProfile>, String> loadAllProfilesFromJson(String resource, byte[] cipherText, CipherAbstract cipher) throws IonicException {
        SdkData.checkTrue(cipherText != null, 40021, resource);
        this.logger.info(String.format("ProfilePersistor, resource=[%s], hash=[%s], size=[%d]", resource, CryptoUtils.sha256ToHexString(cipherText), cipherText.length));
        DeviceProfileSerializer serializer = new DeviceProfileSerializer(cipherText);
        this.initializeCipher(serializer.getHeader());
        ArrayList<DeviceProfile> profiles = new ArrayList<DeviceProfile>();
        String activeDeviceId = null;
        byte[] json = cipher.decrypt(serializer.getBody());
        JsonObject jsonObj = JsonIO.readObject(json);
        try {
            activeDeviceId = JsonSource.getString(jsonObj, "activeDeviceId");
        }
        catch (NullPointerException npe) {
            this.logger.warning("JSON is missing a field activeDeviceId. It has been skipped since it is optional.");
        }
        JsonArray jsonProfiles = JsonSource.getJsonArray(jsonObj, "profiles");
        for (JsonValue jsonProfile : jsonProfiles) {
            int timeStamp;
            String aesCdEiKeyHex;
            String aesCdIdcKeyHex;
            String server;
            String deviceId;
            String deviceName;
            JsonObject value = JsonSource.toJsonObject(jsonProfile, "profiles");
            DeviceProfile profile = new DeviceProfile();
            try {
                deviceName = JsonSource.getString(value, "name");
                deviceId = JsonSource.getString(value, "deviceId");
                server = JsonSource.getString(value, "server");
                aesCdIdcKeyHex = JsonSource.getString(value, "aesCdIdcKey");
                aesCdEiKeyHex = JsonSource.getString(value, "aesCdEiKey");
                timeStamp = JsonSource.getInt(value, "creationTimestamp");
            }
            catch (NullPointerException npe) {
                this.logger.warning("JSON device profile object is missing one or more fields. Profile has been skipped.");
                continue;
            }
            profile.setName(deviceName);
            profile.setDeviceId(deviceId);
            profile.setServer(server);
            profile.setAesCdEiProfileKey(CryptoUtils.hexToBin(aesCdEiKeyHex));
            profile.setAesCdIdcProfileKey(CryptoUtils.hexToBin(aesCdIdcKeyHex));
            profile.setCreationTimestampSecs(timeStamp);
            try {
                profile.isValid();
            }
            catch (IonicException e) {
                throw new IonicException(40029, (Throwable)e);
            }
            profiles.add(profile);
        }
        return new Tuple<List<DeviceProfile>, String>(profiles, activeDeviceId);
    }
}

