/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.device.profile.persistor;

import com.ionic.sdk.cipher.CipherAbstract;
import com.ionic.sdk.cipher.aes.AesGcmCipher;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.rng.CryptoRng;
import com.ionic.sdk.crypto.CryptoUtils;
import com.ionic.sdk.device.profile.DeviceProfile;
import com.ionic.sdk.device.profile.persistor.DeviceProfilePersistorBase;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import com.ionic.sdk.json.JsonTarget;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

public class DeviceProfilePersistorPassword
extends DeviceProfilePersistorBase {
    private final AesGcmCipher cipherCast = (AesGcmCipher)this.getCipher();
    private String password;
    private static final String IONIC_AUTH_DATA = "Ionic Security Inc";
    public static final String FORMAT_PASSWORD = "password";

    public DeviceProfilePersistorPassword(String filePath) throws IonicException {
        super(filePath, (CipherAbstract)new AesGcmCipher());
    }

    public DeviceProfilePersistorPassword(URL url) throws IonicException {
        super(url, (CipherAbstract)new AesGcmCipher());
    }

    public DeviceProfilePersistorPassword(InputStream inputStream) throws IonicException {
        super(inputStream, (CipherAbstract)new AesGcmCipher());
    }

    public DeviceProfilePersistorPassword() throws IonicException {
        super(new AesGcmCipher());
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    @Override
    protected final String getFormat() {
        return FORMAT_PASSWORD;
    }

    @Override
    protected final void initializeCipher(String jsonHeader) throws IonicException {
        byte[] salt = new byte[]{};
        if (jsonHeader != null) {
            JsonObject jsonObject = JsonIO.readObject(Transcoder.utf8().decode(jsonHeader));
            JsonObject extra = JsonSource.getJsonObjectNullable(jsonObject, "extra");
            salt = Transcoder.base64().decode(JsonSource.getString(extra, "salt"));
        }
        int iterations = 2000;
        this.cipherCast.setKey(CryptoUtils.pbkdf2ToBytes(Transcoder.utf8().decode(this.password), salt, 2000L, 32L));
        this.cipherCast.setAuthData(Transcoder.utf8().decode(IONIC_AUTH_DATA));
    }

    @Override
    public final void saveAllProfiles(List<DeviceProfile> profiles, String activeProfile) throws IonicException {
        JsonObjectBuilder extraBuilder = Json.createObjectBuilder();
        int saltBytes = 32;
        JsonTarget.addNotNull(extraBuilder, "salt", Transcoder.base64().encode(new CryptoRng().rand(new byte[32])));
        this.setExtra(JsonIO.write(extraBuilder.build(), false));
        super.saveAllProfiles(profiles, activeProfile);
    }
}

