/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.device.profile.persistor;

import com.ionic.sdk.core.codec.Transcoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DeviceProfileSerializer {
    private final String header;
    private final byte[] body;
    public static final String HEADER_JSON_DELIMITER = "\r\n\r\n";

    public DeviceProfileSerializer(byte[] content) {
        String text = Transcoder.utf8().encode(content);
        Matcher matcher = Pattern.compile(HEADER_JSON_DELIMITER).matcher(text);
        if (matcher.find()) {
            this.header = text.substring(0, matcher.start());
            this.body = Arrays.copyOfRange(content, matcher.end(), content.length);
        } else {
            this.header = null;
            this.body = Arrays.copyOf(content, content.length);
        }
    }

    public String getHeader() {
        return this.header;
    }

    public byte[] getBody() {
        return Arrays.copyOf(this.body, this.body.length);
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(Transcoder.utf8().decode(this.header));
        os.write(Transcoder.utf8().decode(HEADER_JSON_DELIMITER));
        os.write(this.body);
        return os.toByteArray();
    }
}

