/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.device.profile.persistor;

import com.ionic.sdk.cipher.PassThroughCipher;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.device.profile.DeviceProfile;
import com.ionic.sdk.device.profile.persistor.DeviceProfilePersistorPlainText;
import com.ionic.sdk.error.IonicException;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.List;

public class DeviceProfiles {
    private final List<DeviceProfile> profiles;
    private final String activeProfileId;

    public DeviceProfiles(String json) throws IonicException {
        ByteArrayInputStream is = new ByteArrayInputStream(Transcoder.utf8().decode(json));
        DeviceProfilePersistorPlainText persistor = new DeviceProfilePersistorPlainText(is);
        String[] activeProfile = new String[1];
        this.profiles = persistor.loadAllProfiles(activeProfile);
        this.activeProfileId = activeProfile[0];
    }

    public DeviceProfiles(DeviceProfile deviceProfile) {
        this.profiles = Collections.singletonList(deviceProfile);
        this.activeProfileId = deviceProfile.getDeviceId();
    }

    public List<DeviceProfile> getProfiles() {
        return this.profiles;
    }

    public String getActiveProfileId() {
        return this.activeProfileId;
    }

    public String toJson() throws IonicException {
        return Transcoder.utf8().encode(DeviceProfilePersistorPlainText.saveAllProfilesToJson(this.profiles, this.activeProfileId, new PassThroughCipher(null)));
    }
}

