/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.error;

import com.ionic.sdk.agent.SdkVersion;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicServerException;
import com.ionic.sdk.error.SdkError;
import com.ionic.sdk.error.SdkException;

public class IonicException
extends SdkException {
    private static final String SPACER = " - ";
    private static final long serialVersionUID = -7188300090018888838L;

    @Override
    public final int getReturnCode() {
        return super.getReturnCode();
    }

    @Override
    public final String getMessage() {
        return Value.join(SPACER, super.getReturnCode(), super.getMessage(), this.getConversationIdInternal(), SdkVersion.getVersionString());
    }

    public String getConversationId() {
        return this.getConversationIdInternal();
    }

    private String getConversationIdInternal() {
        Throwable cause = this.getCause();
        IonicServerException serverException = cause instanceof IonicServerException ? (IonicServerException)cause : null;
        return serverException == null ? null : serverException.getConversationId();
    }

    public IonicException(int errorCode) {
        super(errorCode);
    }

    public IonicException(int errorCode, Throwable cause) {
        super(errorCode, cause);
    }

    public IonicException(int errorCode, String message) {
        super(errorCode, Value.join(SPACER, SdkError.getErrorString(errorCode), message));
    }

    public IonicException(Throwable cause) {
        super(cause);
    }

    public IonicException(String message, Throwable cause) {
        super(message, cause);
    }

    public IonicException(int errorCode, String message, Throwable cause) {
        super(errorCode, Value.join(SPACER, SdkError.getErrorString(errorCode), message), cause);
    }
}

