/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.error;

import com.ionic.sdk.error.AgentErrorModuleConstants;
import com.ionic.sdk.error.ChunkCryptoErrorModuleConstants;
import com.ionic.sdk.error.CryptoErrorModuleConstants;
import com.ionic.sdk.error.FileCryptoErrorModuleConstants;
import com.ionic.sdk.error.KeyVaultErrorModuleConstants;
import com.ionic.sdk.error.SdkModule;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class SdkError
implements ChunkCryptoErrorModuleConstants,
AgentErrorModuleConstants,
CryptoErrorModuleConstants,
FileCryptoErrorModuleConstants,
KeyVaultErrorModuleConstants {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.ionic.sdk.error.SdkError");
    private static final String PATTERN_ERROR_STRING = "sdkerror.%d.message";
    private static final String PATTERN_ERROR_STRING_DEFAULT = "Unknown / unrecognized error code (%d)";

    private SdkError() {
    }

    public static SdkModule getErrorModule(int errorCode) {
        return SdkModule.getErrorCodeModule(errorCode);
    }

    public static String getErrorString(int errorCode) {
        String errorString = String.format(PATTERN_ERROR_STRING, errorCode);
        try {
            return BUNDLE.getString(errorString);
        }
        catch (MissingResourceException e) {
            return String.format(PATTERN_ERROR_STRING_DEFAULT, errorCode);
        }
    }
}

