/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.error;

public enum SdkModule {
    MODULE_UNKNOWN,
    MODULE_ISAGENT,
    MODULE_ISCRYPTO,
    MODULE_ISFILECRYPTO,
    MODULE_ISFINGERPRINT,
    MODULE_ISCHUNKCRYPTO,
    MODULE_ISXML,
    MODULE_ISZIP,
    MODULE_ISHTTP,
    MODULE_ISIPC,
    MODULE_ISKEYVAULT;

    private static final int BLOCK_SIZE = 10000;

    public static SdkModule getErrorCodeModule(int errorCode) {
        SdkModule module = MODULE_UNKNOWN;
        if (SdkModule.isInRange(errorCode, 20000, 10000)) {
            module = MODULE_ISCHUNKCRYPTO;
        } else if (SdkModule.isInRange(errorCode, 40000, 10000)) {
            module = MODULE_ISAGENT;
        } else if (SdkModule.isInRange(errorCode, 50000, 10000)) {
            module = MODULE_ISCRYPTO;
        } else if (SdkModule.isInRange(errorCode, 80000, 10000)) {
            module = MODULE_ISFILECRYPTO;
        }
        return module;
    }

    private static boolean isInRange(int value, int errorBase, int size) {
        return value >= errorBase && value < errorBase + size;
    }
}

