/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.httpclient;

import com.ionic.sdk.agent.config.AgentConfig;
import com.ionic.sdk.core.io.Stream;
import com.ionic.sdk.httpclient.HttpClient;
import com.ionic.sdk.httpclient.HttpHeader;
import com.ionic.sdk.httpclient.HttpHeaders;
import com.ionic.sdk.httpclient.HttpRequest;
import com.ionic.sdk.httpclient.HttpResponse;
import com.ionic.sdk.httpclient.proxy.ProxyManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class HttpClientDefault
implements HttpClient {
    private final AgentConfig agentConfig;
    private final Proxy proxy;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public HttpClientDefault(AgentConfig agentConfig, String protocol) {
        this.agentConfig = agentConfig;
        this.proxy = ProxyManager.getProxy(protocol);
    }

    @Override
    public HttpResponse execute(HttpRequest httpRequest) throws IOException {
        int httpTimeoutSecs = this.agentConfig.getHttpTimeoutSecs();
        System.setProperty("http.maxRedirects", Integer.toString(this.agentConfig.getMaxRedirects()));
        URL url = httpRequest.getUrl();
        String resource = httpRequest.getResource();
        URL urlRequest = new URL(url.getProtocol(), url.getHost(), url.getPort(), resource);
        this.logger.finest(String.format("URL = %s", urlRequest.toExternalForm()));
        HttpURLConnection connection = (HttpURLConnection)urlRequest.openConnection(this.proxy);
        connection.setConnectTimeout(httpTimeoutSecs * 1000);
        connection.setReadTimeout(httpTimeoutSecs * 1000);
        this.logger.finest(String.format("HttpURLConnection = %s", connection.toString()));
        return this.executeInternal(connection, httpRequest);
    }

    private HttpResponse executeInternal(HttpURLConnection connection, HttpRequest httpRequest) throws IOException {
        ByteArrayInputStream entity = httpRequest.getEntity();
        connection.setRequestMethod(httpRequest.getMethod());
        connection.setDoInput(true);
        connection.setDoOutput(entity != null);
        for (HttpHeader httpHeader : httpRequest.getHttpHeaders()) {
            this.logger.finest(String.format("request header: [%s]=[%s]", httpHeader.getName(), httpHeader.getValue()));
            connection.setRequestProperty(httpHeader.getName(), httpHeader.getValue());
        }
        this.logger.finest(String.format("ready to connect, HttpURLConnection = %s", connection));
        connection.connect();
        this.logger.finest(String.format("connected, HttpURLConnection = %s", connection));
        return this.executeConnected(connection, entity);
    }

    private HttpResponse executeConnected(HttpURLConnection connection, ByteArrayInputStream entity) throws IOException {
        this.logger.finest(String.format("ready to write, HttpURLConnection = %s", connection));
        if (entity != null) {
            Stream.write(connection.getOutputStream(), entity);
        }
        this.logger.finest(String.format("ready to read, HttpURLConnection = %s", connection));
        int statusCode = connection.getResponseCode();
        this.logger.finest(String.format("statusCode = %d, HttpURLConnection = %s", statusCode, connection));
        HttpHeaders httpHeadersResponse = new HttpHeaders(new HttpHeader[0]);
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                this.logger.finest(String.format("response header: [%s]=[%s]", name, value));
                httpHeadersResponse.add(new HttpHeader(name, value));
            }
        }
        this.logger.finest(String.format("#headers = %d, HttpURLConnection = %s", httpHeadersResponse.size(), connection));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Stream.write((OutputStream)os, connection.getInputStream());
        }
        catch (IOException e) {
            Stream.write((OutputStream)os, connection.getErrorStream());
        }
        this.logger.finest(String.format("#entity = %d, HttpURLConnection = %s", os.size(), connection));
        return new HttpResponse(statusCode, httpHeadersResponse, new ByteArrayInputStream(os.toByteArray()));
    }
}

