/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.httpclient;

import com.ionic.sdk.agent.config.AgentConfig;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.httpclient.HttpClient;
import com.ionic.sdk.httpclient.HttpClientDefault;
import java.lang.reflect.Constructor;

@InternalUseOnly
public final class HttpClientFactory {
    private HttpClientFactory() {
    }

    public static HttpClient create(AgentConfig agentConfig, String protocol) throws IonicException {
        SdkData.checkNotNull(agentConfig, AgentConfig.class.getName());
        return Value.isEmpty(agentConfig.getHttpImpl()) ? new HttpClientDefault(agentConfig, protocol) : HttpClientFactory.createReflect(agentConfig.getHttpImpl(), agentConfig, protocol);
    }

    private static HttpClient createReflect(String className, AgentConfig agentConfig, String protocol) throws IonicException {
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> ctor = c.getConstructor(AgentConfig.class, String.class);
            Object object = ctor.newInstance(agentConfig, protocol);
            if (object instanceof HttpClient) {
                return (HttpClient)object;
            }
            throw new IonicException(40012, object.getClass().getName());
        }
        catch (ReflectiveOperationException e) {
            throw new IonicException(40012, (Throwable)e);
        }
    }
}

