/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.httpclient;

import com.ionic.sdk.agent.AgentSdk;
import com.ionic.sdk.agent.config.AgentConfig;
import com.ionic.sdk.core.io.Stream;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.httpclient.HttpClient;
import com.ionic.sdk.httpclient.HttpHeader;
import com.ionic.sdk.httpclient.HttpHeaders;
import com.ionic.sdk.httpclient.HttpRequest;
import com.ionic.sdk.httpclient.HttpResponse;
import com.ionic.sdk.httpclient.proxy.ProxyManager;
import com.ionic.sdk.httpclient.tls.TrustAllHostnameVerifier;
import com.ionic.sdk.httpclient.tls.TrustAllTrustManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public final class HttpClientTrustAll
implements HttpClient {
    private final int httpTimeoutSecs;
    private final int maxRedirects;
    private final Proxy proxy;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final String KEY_PROTOCOL = "protocol";
    private static final String PROTOCOL_DEFAULT = "TLSv1.2";

    public HttpClientTrustAll(AgentConfig agentConfig, String protocol) {
        this.httpTimeoutSecs = agentConfig.getHttpTimeoutSecs();
        this.maxRedirects = agentConfig.getMaxRedirects();
        this.proxy = ProxyManager.getProxy(protocol);
        SSLSocketFactory sslSocketFactoryCtor = null;
        try {
            String sslProtocol = agentConfig.getProperty(KEY_PROTOCOL, PROTOCOL_DEFAULT);
            SSLContext context = AgentSdk.getCrypto().getSSLContext(sslProtocol);
            TrustManager[] trustManagers = new TrustManager[]{new TrustAllTrustManager()};
            context.init(null, trustManagers, null);
            sslSocketFactoryCtor = context.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IonicException e) {
            throw new UnsupportedOperationException(e);
        }
        this.sslSocketFactory = sslSocketFactoryCtor;
        this.hostnameVerifier = new TrustAllHostnameVerifier();
    }

    @Override
    public HttpResponse execute(HttpRequest httpRequest) throws IOException {
        System.setProperty("http.maxRedirects", Integer.toString(this.maxRedirects));
        URL url = httpRequest.getUrl();
        String resource = httpRequest.getResource();
        URL urlRequest = new URL(url.getProtocol(), url.getHost(), url.getPort(), resource);
        this.logger.finest(String.format("URL = %s", urlRequest.toExternalForm()));
        HttpURLConnection connection = (HttpURLConnection)urlRequest.openConnection(this.proxy);
        if (this.sslSocketFactory != null) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            httpsConnection.setSSLSocketFactory(this.sslSocketFactory);
            if (this.hostnameVerifier != null) {
                httpsConnection.setHostnameVerifier(this.hostnameVerifier);
            }
        }
        connection.setConnectTimeout(this.httpTimeoutSecs * 1000);
        connection.setReadTimeout(this.httpTimeoutSecs * 1000);
        this.logger.finest(String.format("HttpURLConnection = %s", connection.toString()));
        return this.executeInternal(connection, httpRequest);
    }

    private HttpResponse executeInternal(HttpURLConnection connection, HttpRequest httpRequest) throws IOException {
        ByteArrayInputStream entity = httpRequest.getEntity();
        connection.setRequestMethod(httpRequest.getMethod());
        connection.setDoInput(true);
        connection.setDoOutput(entity != null);
        for (HttpHeader httpHeader : httpRequest.getHttpHeaders()) {
            connection.setRequestProperty(httpHeader.getName(), httpHeader.getValue());
        }
        this.logger.finest(String.format("ready to connect, HttpURLConnection = %s", connection));
        connection.connect();
        this.logger.finest(String.format("connected, HttpURLConnection = %s", connection));
        return this.executeConnected(connection, entity);
    }

    private HttpResponse executeConnected(HttpURLConnection connection, ByteArrayInputStream entity) throws IOException {
        this.logger.finest(String.format("ready to write, HttpURLConnection = %s", connection));
        if (entity != null) {
            Stream.write(connection.getOutputStream(), entity);
        }
        this.logger.finest(String.format("ready to read, HttpURLConnection = %s", connection));
        int statusCode = connection.getResponseCode();
        this.logger.finest(String.format("statusCode = %d, HttpURLConnection = %s", statusCode, connection));
        HttpHeaders httpHeadersResponse = new HttpHeaders(new HttpHeader[0]);
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                httpHeadersResponse.add(new HttpHeader(name, value));
            }
        }
        this.logger.finest(String.format("#headers = %d, HttpURLConnection = %s", httpHeadersResponse.size(), connection));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Stream.write((OutputStream)os, connection.getInputStream());
        }
        catch (IOException e) {
            Stream.write((OutputStream)os, connection.getErrorStream());
        }
        this.logger.finest(String.format("#entity = %d, HttpURLConnection = %s", os.size(), connection));
        return new HttpResponse(statusCode, httpHeadersResponse, new ByteArrayInputStream(os.toByteArray()));
    }
}

