/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.httpclient.proxy;

import java.net.InetSocketAddress;
import java.net.Proxy;

public final class ProxyManager {
    private static final String PROTOCOL_PROXY_HOST = "%s.proxyHost";
    private static final String PROTOCOL_PROXY_PORT = "%s.proxyPort";
    private static final String DEFAULT_PROXY_PORT = "3128";

    private ProxyManager() {
    }

    public static Proxy getProxy(String protocol) {
        Proxy proxy = Proxy.NO_PROXY;
        String proxyHost = System.getProperty(String.format(PROTOCOL_PROXY_HOST, protocol));
        if (proxyHost != null) {
            String proxyPort = System.getProperty(String.format(PROTOCOL_PROXY_PORT, protocol), DEFAULT_PROXY_PORT);
            InetSocketAddress socketAddress = new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort));
            proxy = new Proxy(Proxy.Type.HTTP, socketAddress);
        }
        return proxy;
    }
}

