/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.json;

import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.error.IonicException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;

@InternalUseOnly
public final class JsonIO {
    private JsonIO() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject readObject(InputStream jsonStream) throws IonicException {
        try (JsonReader jsonReader = Json.createReader((InputStream)jsonStream);){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
        catch (JsonException e) {
            throw new IonicException(40010, (Throwable)e);
        }
    }

    public static JsonObject readObject(byte[] jsonBytes) throws IonicException {
        return JsonIO.readObjectInternal(jsonBytes, null);
    }

    public static JsonObject readObjectNotNull(byte[] jsonBytes) throws IonicException {
        return jsonBytes == null ? null : JsonIO.readObjectInternal(jsonBytes, null);
    }

    public static JsonObject readObject(byte[] jsonBytes, Level level) throws IonicException {
        return JsonIO.readObjectInternal(jsonBytes, level);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonObject readObjectInternal(byte[] jsonBytes, Level level) throws IonicException {
        try (JsonReader jsonReader = Json.createReader((InputStream)new ByteArrayInputStream(jsonBytes));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
        catch (JsonException e) {
            JsonIO.handleJsonException(Transcoder.utf8().encode(jsonBytes), level, e);
            throw new IonicException(40010, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject readObject(String jsonString, int errorCode) throws IonicException {
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonString));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
        catch (JsonException e) {
            throw new IonicException(errorCode, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonArray readArray(String jsonString) throws IonicException {
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonString));){
            JsonArray jsonArray = jsonReader.readArray();
            return jsonArray;
        }
        catch (JsonException e) {
            throw new IonicException(40010, (Throwable)e);
        }
    }

    private static void handleJsonException(String message, Level level, JsonException e) {
        if (level != null) {
            Logger.getLogger(JsonIO.class.getName()).log(level, message, e);
        }
    }

    public static String write(JsonObject jsonObject, boolean pretty) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TreeMap<String, Boolean> config = new TreeMap<String, Boolean>();
        if (pretty) {
            config.put("javax.json.stream.JsonGenerator.prettyPrinting", Boolean.TRUE);
        }
        JsonWriterFactory writerFactory = Json.createWriterFactory(config);
        try (JsonWriter writer = writerFactory.createWriter((OutputStream)os);){
            writer.writeObject(jsonObject);
        }
        return Transcoder.utf8().encode(os.toByteArray());
    }

    public static String write(JsonArray jsonArray, boolean pretty) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TreeMap<String, Boolean> config = new TreeMap<String, Boolean>();
        if (pretty) {
            config.put("javax.json.stream.JsonGenerator.prettyPrinting", Boolean.TRUE);
        }
        JsonWriterFactory writerFactory = Json.createWriterFactory(config);
        try (JsonWriter writer = writerFactory.createWriter((OutputStream)os);){
            writer.writeArray(jsonArray);
        }
        return Transcoder.utf8().encode(os.toByteArray());
    }
}

