/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.json;

import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.util.Iterator;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

@InternalUseOnly
public final class JsonSource {
    private JsonSource() {
    }

    public static JsonString toJsonString(JsonValue jsonValue, String message) throws IonicException {
        SdkData.checkTrue(jsonValue != null, 40004, message);
        SdkData.checkTrue(jsonValue instanceof JsonString, 40005, message);
        return (JsonString)jsonValue;
    }

    public static JsonObject toJsonObject(JsonValue jsonValue, String message) throws IonicException {
        SdkData.checkTrue(jsonValue != null, 40004, message);
        SdkData.checkTrue(jsonValue instanceof JsonObject, 40005, message);
        return (JsonObject)jsonValue;
    }

    public static JsonArray toJsonArray(JsonValue jsonValue, String message) throws IonicException {
        SdkData.checkTrue(jsonValue != null, 40004, message);
        SdkData.checkTrue(jsonValue instanceof JsonArray, 40005, message);
        return (JsonArray)jsonValue;
    }

    public static String toString(JsonValue jsonValue) {
        String value = jsonValue == null ? null : (jsonValue instanceof JsonString ? ((JsonString)jsonValue).getString() : jsonValue.toString());
        return value;
    }

    public static int toInt(JsonValue jsonValue) {
        return jsonValue instanceof JsonNumber ? ((JsonNumber)jsonValue).intValue() : 0;
    }

    public static long toLong(JsonValue jsonValue) {
        return jsonValue instanceof JsonNumber ? ((JsonNumber)jsonValue).longValueExact() : 0L;
    }

    public static Iterator<Map.Entry<String, JsonValue>> getIterator(JsonObject jsonObject) throws IonicException {
        SdkData.checkNotNull(jsonObject, JsonObject.class.getSimpleName());
        return jsonObject.entrySet().iterator();
    }

    public static Iterator<JsonValue> getIterator(JsonArray jsonArray) throws IonicException {
        SdkData.checkNotNull(jsonArray, JsonArray.class.getSimpleName());
        return jsonArray.iterator();
    }

    public static JsonValue.ValueType getValueType(JsonObject jsonObject, String name) {
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)name);
        return jsonValue == null ? null : jsonValue.getValueType();
    }

    public static JsonValue.ValueType getValueType(JsonValue jsonValue) {
        return jsonValue == null ? null : jsonValue.getValueType();
    }

    public static JsonObject getJsonObjectNullable(JsonObject jsonObject, String name) throws IonicException {
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)name);
        if (jsonValue != null) {
            SdkData.checkTrue(jsonValue instanceof JsonObject, 40005, name);
        }
        return (JsonObject)jsonValue;
    }

    public static JsonObject getJsonObject(JsonObject jsonObject, String name) throws IonicException {
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)name);
        SdkData.checkTrue(jsonValue != null, 40004, name);
        SdkData.checkTrue(jsonValue instanceof JsonObject, 40005, name);
        return (JsonObject)jsonValue;
    }

    public static JsonArray getJsonArray(JsonObject jsonObject, String name) throws IonicException {
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)name);
        SdkData.checkTrue(jsonValue != null, 40004, name);
        SdkData.checkTrue(jsonValue instanceof JsonArray, 40005, name);
        return (JsonArray)jsonValue;
    }

    public static JsonArray getJsonArrayNullable(JsonObject jsonObject, String name) throws IonicException {
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)name);
        if (jsonValue != null) {
            SdkData.checkTrue(jsonValue instanceof JsonArray, 40005, name);
        }
        return (JsonArray)jsonValue;
    }

    public static JsonString getJsonString(JsonObject jsonObject, String name) throws IonicException {
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)name);
        SdkData.checkTrue(jsonValue != null, 40004, name);
        SdkData.checkTrue(jsonValue instanceof JsonString, 40005, name);
        return (JsonString)jsonValue;
    }

    public static JsonNumber getJsonNumber(JsonObject jsonObject, String name) throws IonicException {
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)name);
        SdkData.checkTrue(jsonValue != null, 40004, name);
        SdkData.checkTrue(jsonValue instanceof JsonNumber, 40005, name);
        return (JsonNumber)jsonValue;
    }

    public static String getString(JsonObject jsonObject, String name) {
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)name);
        return jsonValue instanceof JsonString ? ((JsonString)jsonValue).getString() : null;
    }

    public static boolean getBoolean(JsonObject jsonObject, String name) {
        return jsonObject.getBoolean(name, false);
    }

    public static int getInt(JsonObject jsonObject, String name) {
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)name);
        return jsonValue instanceof JsonNumber ? ((JsonNumber)jsonValue).intValue() : 0;
    }

    public static long getLong(JsonObject jsonObject, String name) {
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)name);
        return jsonValue instanceof JsonNumber ? ((JsonNumber)jsonValue).longValueExact() : 0L;
    }

    public static boolean isSize(JsonObject jsonObject, int size) throws IonicException {
        SdkData.checkNotNull(jsonObject, JsonObject.class.getName());
        return jsonObject.size() == size;
    }

    public static boolean isSize(JsonArray jsonArray, int size) throws IonicException {
        SdkData.checkNotNull(jsonArray, JsonArray.class.getName());
        return jsonArray.size() == size;
    }
}

