/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.keyvault;

import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.keyvault.KeyVaultInterface;
import com.ionic.sdk.keyvault.KeyVaultKey;
import com.ionic.sdk.keyvault.KeyVaultKeyRecord;
import com.ionic.sdk.keyvault.KeyVaultTimeUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;

public abstract class KeyVaultBase
extends KeyVaultInterface {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    protected static final int VAULT_SECURITY_LEVEL = 100;
    protected Map<String, KeyVaultKeyRecord> mapKeyRecords = new TreeMap<String, KeyVaultKeyRecord>();
    private long lastExpirationSweepServerTimeUtcSeconds = 0L;
    private static final int EXPIRATION_SWEEP_INTERVAL_SECS = 10;

    private void validateKey(KeyVaultKey key) throws IonicException {
        if (key.getKeyId().length() == 0) {
            throw new IonicException(16015, "Invalid protection key. Key ID is empty.");
        }
        if (key.getKeyBytes().length != 32) {
            throw new IonicException(16015, String.format("Invalid protection key. Invalid key data length (expected %d, got %d).", 32, key.getKeyBytes().length));
        }
    }

    private boolean mergeKeyRecords(Map<String, KeyVaultKeyRecord> mapKeyRecordsFromDisk, Map<String, KeyVaultKeyRecord> mapKeyRecordsFromMemoryInOut) {
        KeyVaultKeyRecord memRecord;
        boolean bNeedsWriteToDiskOut = false;
        for (KeyVaultKeyRecord diskRecord : mapKeyRecordsFromDisk.values()) {
            memRecord = mapKeyRecordsFromMemoryInOut.get(diskRecord.getKeyId());
            if (memRecord != null) {
                if (!memRecord.isAlive()) continue;
                if (memRecord.getIssuedServerTimeUtcSeconds() == diskRecord.getIssuedServerTimeUtcSeconds()) {
                    memRecord.setState(KeyVaultKeyRecord.State.KR_STORED);
                    continue;
                }
                if (memRecord.getIssuedServerTimeUtcSeconds() >= diskRecord.getIssuedServerTimeUtcSeconds()) continue;
                mapKeyRecordsFromMemoryInOut.put(diskRecord.getKeyId(), new KeyVaultKeyRecord(diskRecord));
                continue;
            }
            mapKeyRecordsFromMemoryInOut.put(diskRecord.getKeyId(), new KeyVaultKeyRecord(diskRecord));
        }
        Iterator<KeyVaultKeyRecord> memKeyIter = mapKeyRecordsFromMemoryInOut.values().iterator();
        while (memKeyIter.hasNext()) {
            memRecord = memKeyIter.next();
            if (memRecord.getState() != KeyVaultKeyRecord.State.KR_ADDED && mapKeyRecordsFromDisk.get(memRecord.getKeyId()) == null) {
                memKeyIter.remove();
                continue;
            }
            if (memRecord.getState() == KeyVaultKeyRecord.State.KR_STORED) continue;
            bNeedsWriteToDiskOut = true;
        }
        return bNeedsWriteToDiskOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final int setKeyInternal(KeyVaultKey key, boolean bAddIfNotFound) throws IonicException {
        this.logger.finest(String.format("key.getKeyId() = %s", key.getKeyId()));
        KeyVaultBase keyVaultBase = this;
        synchronized (keyVaultBase) {
            this.validateKey(key);
            KeyVaultKeyRecord record = this.mapKeyRecords.get(key.getKeyId());
            if (record != null && record.isAlive()) {
                if (record.getIssuedServerTimeUtcSeconds() < key.getIssuedServerTimeUtcSeconds()) {
                    this.mapKeyRecords.put(key.getKeyId(), new KeyVaultKeyRecord(key, KeyVaultKeyRecord.State.KR_UPDATED));
                    return 0;
                }
                return 16007;
            }
            if (bAddIfNotFound) {
                this.mapKeyRecords.put(key.getKeyId(), new KeyVaultKeyRecord(key, KeyVaultKeyRecord.State.KR_ADDED));
                return 0;
            }
            this.logger.severe("An attempt to update a key was ignored because the key does not exist in the key vault and bAddIfNotFound = false.");
            return 16006;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final KeyVaultKey getKey(String keyId) {
        this.logger.finest(String.format("keyId = %s", keyId));
        KeyVaultBase keyVaultBase = this;
        synchronized (keyVaultBase) {
            this.expireKeysInternal(false);
            KeyVaultKeyRecord record = this.mapKeyRecords.get(keyId);
            if (record == null || !record.isAlive()) {
                return null;
            }
            return new KeyVaultKey(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Vector<KeyVaultKey> getKeys(Set<String> setKeyIds) {
        this.logger.finest(String.format("setKeyIds.size() = %d", setKeyIds.size()));
        KeyVaultBase keyVaultBase = this;
        synchronized (keyVaultBase) {
            this.expireKeysInternal(false);
            Vector<KeyVaultKey> vecKeysLocal = new Vector<KeyVaultKey>();
            for (String keyId : setKeyIds) {
                KeyVaultKeyRecord record = this.mapKeyRecords.get(keyId);
                if (record == null || !record.isAlive()) continue;
                vecKeysLocal.add(new KeyVaultKey(record));
            }
            return vecKeysLocal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<String> getAllKeyIds() {
        KeyVaultBase keyVaultBase = this;
        synchronized (keyVaultBase) {
            this.expireKeysInternal(false);
            TreeSet<String> setKeyIdsOut = new TreeSet<String>();
            setKeyIdsOut.clear();
            for (KeyVaultKeyRecord record : this.mapKeyRecords.values()) {
                if (!record.isAlive()) continue;
                setKeyIdsOut.add(record.getKeyId());
            }
            return setKeyIdsOut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Vector<KeyVaultKey> getAllKeys() {
        KeyVaultBase keyVaultBase = this;
        synchronized (keyVaultBase) {
            this.expireKeysInternal(false);
            Vector<KeyVaultKey> vecKeysLocal = new Vector<KeyVaultKey>();
            for (KeyVaultKeyRecord record : this.mapKeyRecords.values()) {
                if (!record.isAlive()) continue;
                vecKeysLocal.add(new KeyVaultKey(record));
            }
            return vecKeysLocal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getKeyCount() {
        KeyVaultBase keyVaultBase = this;
        synchronized (keyVaultBase) {
            this.expireKeysInternal(false);
            int nCount = 0;
            for (KeyVaultKeyRecord record : this.mapKeyRecords.values()) {
                if (!record.isAlive()) continue;
                ++nCount;
            }
            return nCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasKey(String keyId) {
        KeyVaultBase keyVaultBase = this;
        synchronized (keyVaultBase) {
            this.expireKeysInternal(false);
            KeyVaultKeyRecord record = this.mapKeyRecords.get(keyId);
            return record != null && record.isAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeKey(KeyVaultKey key) {
        KeyVaultBase keyVaultBase = this;
        synchronized (keyVaultBase) {
            return this.removeKeyImpl(key.getKeyId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeKey(String keyId) {
        KeyVaultBase keyVaultBase = this;
        synchronized (keyVaultBase) {
            return this.removeKeyImpl(keyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<String> removeKeys(Set<String> keyIds) {
        KeyVaultBase keyVaultBase = this;
        synchronized (keyVaultBase) {
            TreeSet<String> keyIdsNotFoundOptOut = new TreeSet<String>();
            for (String keyId : keyIds) {
                if (this.removeKeyImpl(keyId)) continue;
                keyIdsNotFoundOptOut.add(keyId);
            }
            return keyIdsNotFoundOptOut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearAllKeys() {
        KeyVaultBase keyVaultBase = this;
        synchronized (keyVaultBase) {
            for (KeyVaultKeyRecord record : this.mapKeyRecords.values()) {
                if (!record.isAlive()) continue;
                record.setState(KeyVaultKeyRecord.State.KR_REMOVED);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void expireKeysInternal(Set<String> keyIdsExpiredOptOut) {
        KeyVaultBase keyVaultBase = this;
        synchronized (keyVaultBase) {
            this.expireKeysInternal(true, keyIdsExpiredOptOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void sync() throws IonicException {
        KeyVaultBase keyVaultBase = this;
        synchronized (keyVaultBase) {
            this.expireKeysInternal(false);
            boolean bNeedsWriteToDisk = false;
            Map<String, KeyVaultKeyRecord> mapKeyRecordsFromDisk = null;
            try {
                mapKeyRecordsFromDisk = this.loadAllKeyRecords();
            }
            catch (IonicException e) {
                if (e.getReturnCode() == 16016) {
                    bNeedsWriteToDisk = true;
                }
                if (e.getReturnCode() == 16013) {
                    bNeedsWriteToDisk = this.hasChangesInternal();
                }
                throw e;
            }
            if (mapKeyRecordsFromDisk != null) {
                bNeedsWriteToDisk = this.mergeKeyRecords(mapKeyRecordsFromDisk, this.mapKeyRecords);
            }
            if (bNeedsWriteToDisk) {
                this.logger.finest("Sync operation will now perform save operation.");
                this.saveAllKeyRecords(this.mapKeyRecords);
                Iterator<KeyVaultKeyRecord> itr = this.mapKeyRecords.values().iterator();
                while (itr.hasNext()) {
                    KeyVaultKeyRecord record = itr.next();
                    if (record.isAlive()) {
                        record.setState(KeyVaultKeyRecord.State.KR_STORED);
                        continue;
                    }
                    itr.remove();
                }
            } else {
                this.logger.finest("Sync operation skipped save operation since there are no changes.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasChanges() {
        KeyVaultBase keyVaultBase = this;
        synchronized (keyVaultBase) {
            return this.hasChangesInternal();
        }
    }

    private boolean removeKeyImpl(String keyId) {
        KeyVaultKeyRecord record = this.mapKeyRecords.get(keyId);
        if (record == null || !record.isAlive()) {
            return false;
        }
        record.setState(KeyVaultKeyRecord.State.KR_REMOVED);
        return true;
    }

    protected abstract Map<String, KeyVaultKeyRecord> loadAllKeyRecords() throws IonicException;

    protected abstract int saveAllKeyRecords(Map<String, KeyVaultKeyRecord> var1) throws IonicException;

    private void expireKeysInternal(boolean bForceSweep, Set<String> keyIdsExpiredOptOut) {
        long currentServerTimeUtcSeconds = KeyVaultTimeUtil.getCurrentServerTimeUtcSeconds();
        if (!bForceSweep && currentServerTimeUtcSeconds > this.lastExpirationSweepServerTimeUtcSeconds + 10L) {
            return;
        }
        this.lastExpirationSweepServerTimeUtcSeconds = currentServerTimeUtcSeconds;
        for (KeyVaultKeyRecord record : this.mapKeyRecords.values()) {
            if (!record.isAlive() || !record.isExpired(currentServerTimeUtcSeconds)) continue;
            if (keyIdsExpiredOptOut != null) {
                keyIdsExpiredOptOut.add(record.getKeyId());
            }
            record.setState(KeyVaultKeyRecord.State.KR_REMOVED);
        }
    }

    private void expireKeysInternal(boolean bForceSweep) {
        this.expireKeysInternal(bForceSweep, null);
    }

    protected final boolean hasChangesInternal() {
        for (KeyVaultKeyRecord record : this.mapKeyRecords.values()) {
            if (record.getState() == KeyVaultKeyRecord.State.KR_STORED) continue;
            return true;
        }
        return false;
    }
}

