/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.keyvault;

import com.ionic.sdk.agent.key.KeyAttributesMap;
import com.ionic.sdk.agent.key.KeyObligationsMap;
import com.ionic.sdk.cipher.CipherAbstract;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.io.Stream;
import com.ionic.sdk.crypto.CryptoUtils;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import com.ionic.sdk.json.JsonTarget;
import com.ionic.sdk.keyvault.KeyVaultKeyRecord;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class KeyVaultEncryptedFile {
    private static final byte[] HEADER_DELIM = new byte[]{13, 10, 13, 10};
    private static final int HEADER_DELIM_SIZE = HEADER_DELIM.length;
    private static final int HEADER_MAX_SIZE = 200;
    private static final String FILE_VERSION_LATEST = "1.0";
    private static final String FIELD_KEYVAULT_ID = "keyVaultId";
    private static final String FIELD_CIPHER_ID = "cipherId";
    private static final String FIELD_FILE_VERSION = "fileVersion";
    private static final String FIELD_KEY_ID = "keyId";
    private static final String FIELD_KEY_DATA = "keyData";
    private static final String FIELD_KEY_ATTRIBUTES = "attrs";
    private static final String FIELD_KEY_MUTABLE_ATTRIBUTES = "mattrs";
    private static final String FIELD_KEY_OBLIGATIONS = "obligs";
    private static final String FIELD_KEY_EXPIRATION_TIME = "expireTimeUtc";
    private static final String FIELD_KEY_ISSUED_TIME = "issuedTimeUtc";
    private static final byte[] BODY_CONTENT_EMPTY = new byte[]{69, 77, 80, 84, 89};
    private static final String NEWLINE = "\n";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final String ARRAY_PARSING_ERROR_MESSAGE = "Found JSON value that isn't an array in attribute map.";
    private String keyVaultId;

    private static boolean areBytesInBuffer(byte[] search, byte[] buffer, int offset) {
        for (int i = 0; i < search.length; ++i) {
            if (search[i] == buffer[offset + i]) continue;
            return false;
        }
        return true;
    }

    private void readJsonHeader(String jsonString, String keyVaultId, String cipherId, String fileVersion) throws IonicException {
        JsonObject jsonHeader = JsonIO.readObject(jsonString, 80011);
        String headerKeyVaultId = JsonSource.getString(jsonHeader, FIELD_KEYVAULT_ID);
        if (headerKeyVaultId == null) {
            this.logger.severe(String.format("Failed to read JSON header field '%s', rc = %d.", FIELD_KEYVAULT_ID, 80011));
            throw new IonicException(80011);
        }
        if (!keyVaultId.equals(headerKeyVaultId)) {
            this.logger.severe(String.format("Cannot open encrypted key vault file because it is of the wrong type (found key vault ID = '%s', expected '%s')", headerKeyVaultId, keyVaultId));
            throw new IonicException(16012);
        }
        String headerCipherId = JsonSource.getString(jsonHeader, FIELD_CIPHER_ID);
        if (headerCipherId == null) {
            this.logger.severe(String.format("Failed to read JSON header field '%s', rc = %d.", FIELD_CIPHER_ID, 80011));
            throw new IonicException(80011);
        }
        if (!headerCipherId.equals(cipherId)) {
            this.logger.severe(String.format("Cannot open encrypted key vault file because it is of the wrong type (found cipher ID = '%s', expected '%s')", headerCipherId, cipherId));
            throw new IonicException(16012);
        }
        String headerFileVersion = JsonSource.getString(jsonHeader, FIELD_FILE_VERSION);
        if (headerFileVersion == null) {
            this.logger.severe(String.format("Failed to read JSON header field '%s', rc = %d.", FIELD_FILE_VERSION, 80011));
            throw new IonicException(80011);
        }
        if (!headerFileVersion.equals(fileVersion)) {
            this.logger.severe(String.format("Cannot open encrypted key vault file because the version is not supported (found version = '%s', expected '%s')", headerFileVersion, fileVersion));
            throw new IonicException(16017);
        }
    }

    private KeyAttributesMap readJsonMapOfAttributes(JsonObject keyObject) throws IonicException {
        KeyAttributesMap attributeMap = new KeyAttributesMap();
        JsonObject jsonAsMap = keyObject;
        for (Map.Entry entry : jsonAsMap.entrySet()) {
            String key = (String)entry.getKey();
            JsonValue value = (JsonValue)entry.getValue();
            JsonArray array = JsonSource.toJsonArray(value, ARRAY_PARSING_ERROR_MESSAGE);
            ArrayList<String> list = new ArrayList<String>();
            for (JsonValue listVal : array) {
                String listStr = JsonSource.toString(listVal);
                if (listStr == null) {
                    this.logger.severe("Found JSON array value that is not a string.");
                    throw new IonicException(16005);
                }
                list.add(listStr);
            }
            if (list.size() <= 0) continue;
            attributeMap.put(key, list);
        }
        return attributeMap;
    }

    private KeyObligationsMap readJsonMapOfObligations(JsonObject keyObject) throws IonicException {
        KeyObligationsMap attributeMap = new KeyObligationsMap();
        JsonObject jsonAsMap = keyObject;
        for (Map.Entry entry : jsonAsMap.entrySet()) {
            String key = (String)entry.getKey();
            JsonValue value = (JsonValue)entry.getValue();
            JsonArray array = JsonSource.toJsonArray(value, ARRAY_PARSING_ERROR_MESSAGE);
            ArrayList<String> list = new ArrayList<String>();
            for (JsonValue listVal : array) {
                String listStr = JsonSource.toString(listVal);
                if (listStr == null) {
                    this.logger.severe("Found JSON array value that is not a string.");
                    throw new IonicException(16005);
                }
                list.add(listStr);
            }
            if (list.size() <= 0) continue;
            attributeMap.put(key, list);
        }
        return attributeMap;
    }

    private KeyVaultKeyRecord readJsonKeyObject(JsonObject keyObject) throws IonicException {
        KeyVaultKeyRecord keyRecord = new KeyVaultKeyRecord();
        keyRecord.setState(KeyVaultKeyRecord.State.KR_STORED);
        String keyIdOut = JsonSource.getString(keyObject, FIELD_KEY_ID);
        if (keyIdOut == null) {
            this.logger.severe(String.format("Failed to read JSON key ID field '%s', rc = %d.", FIELD_KEY_ID, 80011));
            throw new IonicException(80011);
        }
        keyRecord.setKeyId(keyIdOut);
        String keyDataBase64 = JsonSource.getString(keyObject, FIELD_KEY_DATA);
        if (keyDataBase64 == null) {
            this.logger.severe(String.format("Failed to read JSON key ID field '%s', rc = %d.", FIELD_KEY_DATA, 80011));
            throw new IonicException(80011);
        }
        keyRecord.setKeyBytes(CryptoUtils.base64ToBin(keyDataBase64));
        long expire = JsonSource.getLong(keyObject, FIELD_KEY_EXPIRATION_TIME);
        if (expire == 0L) {
            this.logger.severe(String.format("Failed to read JSON key ID field '%s', rc = %d.", FIELD_KEY_EXPIRATION_TIME, 80011));
            throw new IonicException(80011);
        }
        keyRecord.setExpirationServerTimeUtcSeconds(expire);
        long issue = JsonSource.getLong(keyObject, FIELD_KEY_ISSUED_TIME);
        if (issue == 0L) {
            this.logger.severe(String.format("Failed to read JSON key ID field '%s', rc = %d.", FIELD_KEY_ISSUED_TIME, 80011));
            throw new IonicException(80011);
        }
        keyRecord.setIssuedServerTimeUtcSeconds(issue);
        JsonObject attrObject = JsonSource.getJsonObject(keyObject, FIELD_KEY_ATTRIBUTES);
        if (attrObject == null) {
            this.logger.severe(String.format("Failed to read JSON key ID field '%s', rc = %d.", FIELD_KEY_ATTRIBUTES, 80011));
            throw new IonicException(80011);
        }
        keyRecord.setKeyAttributes(this.readJsonMapOfAttributes(attrObject));
        JsonObject mutAttrObject = JsonSource.getJsonObject(keyObject, FIELD_KEY_MUTABLE_ATTRIBUTES);
        if (mutAttrObject == null) {
            this.logger.severe(String.format("Failed to read JSON key ID field '%s', rc = %d.", FIELD_KEY_MUTABLE_ATTRIBUTES, 80011));
            throw new IonicException(80011);
        }
        keyRecord.setMutableKeyAttributes(this.readJsonMapOfAttributes(mutAttrObject));
        JsonObject obligObject = JsonSource.getJsonObject(keyObject, FIELD_KEY_OBLIGATIONS);
        if (obligObject == null) {
            this.logger.severe(String.format("Failed to read JSON key ID field '%s', rc = %d.", FIELD_KEY_OBLIGATIONS, 80011));
            throw new IonicException(80011);
        }
        keyRecord.setKeyObligations(this.readJsonMapOfObligations(obligObject));
        return keyRecord;
    }

    private Map<String, KeyVaultKeyRecord> readJsonBody(String jsonBody) throws IonicException {
        String[] keyRowsJson;
        TreeMap<String, KeyVaultKeyRecord> mapKeyRecords = new TreeMap<String, KeyVaultKeyRecord>();
        for (String keyRowJson : keyRowsJson = jsonBody.split(NEWLINE, 0)) {
            JsonObject jsonRow = JsonIO.readObject(keyRowJson, 80011);
            if (jsonRow == null) {
                this.logger.warning("Skipped key entry because the JSON string is invalid.");
                continue;
            }
            KeyVaultKeyRecord record = this.readJsonKeyObject(jsonRow);
            mapKeyRecords.put(record.getKeyId(), record);
        }
        return mapKeyRecords;
    }

    private JsonObject writeJsonMapOfVectors(Map<String, List<String>> mapOfVectors) {
        JsonObjectBuilder mapBuilder = Json.createObjectBuilder();
        for (Map.Entry<String, List<String>> entry : mapOfVectors.entrySet()) {
            JsonArray jsonList = JsonTarget.toJsonArray((Collection<String>)entry.getValue());
            JsonTarget.addNotNull(mapBuilder, entry.getKey(), (JsonValue)jsonList);
        }
        return mapBuilder.build();
    }

    public KeyVaultEncryptedFile(String keyVaultId) {
        this.keyVaultId = keyVaultId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, KeyVaultKeyRecord> loadAllKeyRecordsFromFile(String filePath, CipherAbstract cipher) throws IonicException {
        byte[] fileDataBytes = null;
        KeyVaultEncryptedFile keyVaultEncryptedFile = this;
        synchronized (keyVaultEncryptedFile) {
            File file = new File(filePath);
            if (file.exists() && file.length() > 0L) {
                try {
                    fileDataBytes = Stream.read(file);
                    SdkData.checkTrue(file.length() == (long)fileDataBytes.length, 16009);
                }
                catch (IOException e) {
                    this.logger.warning(String.format("loadAllKeyRecordsFromFile threw an IO Exception %s", e.toString()));
                    throw new IonicException(16008, (Throwable)e);
                }
            }
        }
        return this.loadAllKeyRecordsFromMemoryInternal(fileDataBytes, cipher);
    }

    public Map<String, KeyVaultKeyRecord> loadAllKeyRecordsFromMemory(byte[] dataBytes, CipherAbstract cipher) throws IonicException {
        return this.loadAllKeyRecordsFromMemoryInternal(dataBytes, cipher);
    }

    private Map<String, KeyVaultKeyRecord> loadAllKeyRecordsFromMemoryInternal(byte[] dataBytes, CipherAbstract cipher) throws IonicException {
        if (this.keyVaultId.length() == 0) {
            this.logger.severe("Key vault ID cannot be empty.");
            throw new IonicException(16004);
        }
        int headerDelimIndex = 0;
        for (int i = 0; i < dataBytes.length - HEADER_DELIM_SIZE && i < 200; ++i) {
            if (!KeyVaultEncryptedFile.areBytesInBuffer(HEADER_DELIM, dataBytes, i)) continue;
            headerDelimIndex = i;
            break;
        }
        if (headerDelimIndex <= 0) {
            this.logger.severe("Failed to load key vault data because no header was found.");
            throw new IonicException(16010);
        }
        byte[] header = new byte[headerDelimIndex];
        System.arraycopy(dataBytes, 0, header, 0, headerDelimIndex);
        this.readJsonHeader(Transcoder.utf8().encode(header), this.keyVaultId, cipher.getId(), FILE_VERSION_LATEST);
        byte[] encryptedBody = Arrays.copyOfRange(dataBytes, headerDelimIndex + HEADER_DELIM_SIZE, dataBytes.length);
        byte[] jsonBody = cipher.decrypt(encryptedBody);
        if (jsonBody == null) {
            this.logger.severe(String.format("Failed to decrypt JSON body data, rc = %d.", 16002));
            throw new IonicException(16002);
        }
        if (jsonBody.length != 0 && !Arrays.equals(jsonBody, BODY_CONTENT_EMPTY)) {
            return this.readJsonBody(Transcoder.utf8().encode(jsonBody));
        }
        return new TreeMap<String, KeyVaultKeyRecord>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAllKeyRecordsToFile(CipherAbstract cipher, Map<String, KeyVaultKeyRecord> mapKeyRecords, String filePath) throws IonicException {
        byte[] fileDataBytes = this.saveAllKeyRecordsToMemoryInternal(cipher, mapKeyRecords);
        KeyVaultEncryptedFile keyVaultEncryptedFile = this;
        synchronized (keyVaultEncryptedFile) {
            File file = new File(filePath);
            File folder = new File(filePath).getParentFile();
            if (folder != null && !folder.exists() && !folder.mkdirs()) {
                this.logger.warning(String.format("saveAllKeyRecordsToFile failed to create folder: %s", folder.getAbsolutePath()));
                throw new IonicException(40013);
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(fileDataBytes);
                fos.close();
            }
            catch (FileNotFoundException e) {
                this.logger.warning(String.format("saveAllKeyRecordsToFile threw an Exception %s", e.toString()));
                throw new IonicException(16008, (Throwable)e);
            }
            catch (IOException e) {
                this.logger.warning(String.format("saveAllKeyRecordsToFile threw an IO Exception %s", e.toString()));
                throw new IonicException(16008, (Throwable)e);
            }
        }
    }

    public byte[] saveAllKeyRecordsToMemory(CipherAbstract cipher, Map<String, KeyVaultKeyRecord> mapKeyRecords) throws IonicException {
        return this.saveAllKeyRecordsToMemoryInternal(cipher, mapKeyRecords);
    }

    private byte[] saveAllKeyRecordsToMemoryInternal(CipherAbstract cipher, Map<String, KeyVaultKeyRecord> mapKeyRecords) throws IonicException {
        if (this.keyVaultId.length() == 0) {
            this.logger.severe("Key vault ID cannot be empty.");
            throw new IonicException(16004);
        }
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        JsonTarget.addNotNull(objectBuilder, FIELD_KEYVAULT_ID, this.keyVaultId);
        JsonTarget.addNotNull(objectBuilder, FIELD_CIPHER_ID, cipher.getId());
        JsonTarget.addNotNull(objectBuilder, FIELD_FILE_VERSION, FILE_VERSION_LATEST);
        String headerString = JsonIO.write(objectBuilder.build(), false);
        StringBuilder stringBuf = new StringBuilder();
        for (Map.Entry<String, KeyVaultKeyRecord> entry : mapKeyRecords.entrySet()) {
            KeyVaultKeyRecord record = entry.getValue();
            if (!record.isAlive()) continue;
            JsonObjectBuilder recordBuilder = Json.createObjectBuilder();
            JsonTarget.addNotNull(recordBuilder, FIELD_KEY_ID, record.getKeyId());
            JsonTarget.add(recordBuilder, FIELD_KEY_ISSUED_TIME, record.getIssuedServerTimeUtcSeconds());
            JsonTarget.add(recordBuilder, FIELD_KEY_EXPIRATION_TIME, record.getExpirationServerTimeUtcSeconds());
            JsonTarget.addNotNull(recordBuilder, FIELD_KEY_DATA, CryptoUtils.binToBase64(record.getKeyBytes()));
            JsonTarget.add(recordBuilder, FIELD_KEY_ATTRIBUTES, this.writeJsonMapOfVectors(record.getKeyAttributes()));
            JsonTarget.add(recordBuilder, FIELD_KEY_MUTABLE_ATTRIBUTES, this.writeJsonMapOfVectors(record.getMutableKeyAttributes()));
            JsonTarget.add(recordBuilder, FIELD_KEY_OBLIGATIONS, this.writeJsonMapOfVectors(record.getKeyObligations()));
            stringBuf.append(JsonIO.write(recordBuilder.build(), false));
            stringBuf.append(NEWLINE);
        }
        String bodyPlainText = stringBuf.toString();
        if (bodyPlainText.length() == 0) {
            bodyPlainText = Transcoder.utf8().encode(BODY_CONTENT_EMPTY);
        }
        byte[] bodyCipherText = cipher.encrypt(bodyPlainText);
        byte[] headerBytes = Transcoder.utf8().decode(headerString);
        byte[] savedBytes = new byte[headerBytes.length + HEADER_DELIM_SIZE + bodyCipherText.length];
        System.arraycopy(headerBytes, 0, savedBytes, 0, headerBytes.length);
        System.arraycopy(HEADER_DELIM, 0, savedBytes, headerBytes.length, HEADER_DELIM_SIZE);
        System.arraycopy(bodyCipherText, 0, savedBytes, headerBytes.length + HEADER_DELIM_SIZE, bodyCipherText.length);
        return savedBytes;
    }
}

