/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.keyvault;

import java.io.File;

public class KeyVaultFileModTracker {
    private final String filePath;
    private long lastFileSize = 0L;
    private long lastFileModTime = 0L;
    private boolean haslastFileInfo = false;

    public KeyVaultFileModTracker(String filePath) {
        this.filePath = filePath;
    }

    public final String getFilePath() {
        return this.filePath;
    }

    public Result recordFileInfo() {
        File trackedFile = new File(this.filePath);
        if (!trackedFile.exists()) {
            return Result.FILE_NOT_FOUND;
        }
        Result result = Result.FILE_CHANGED;
        long fileTime = trackedFile.lastModified();
        long fileSize = trackedFile.length();
        if (this.haslastFileInfo && fileTime == this.lastFileModTime && fileSize == this.lastFileSize) {
            result = Result.FILE_UNCHANGED;
        }
        if (result == Result.FILE_CHANGED) {
            this.lastFileModTime = fileTime;
            this.lastFileSize = fileSize;
            this.haslastFileInfo = true;
        }
        return result;
    }

    public static enum Result {
        FILE_NOT_FOUND,
        FILE_UNCHANGED,
        FILE_CHANGED;

    }
}

