/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.keyvault;

import com.ionic.sdk.agent.key.AgentKey;
import com.ionic.sdk.agent.key.KeyAttributesMap;
import com.ionic.sdk.agent.key.KeyObligationsMap;
import com.ionic.sdk.keyvault.KeyVaultTimeUtil;
import java.util.Arrays;
import java.util.Objects;

public class KeyVaultKey {
    private String keyId;
    private byte[] keyBytes;
    private KeyAttributesMap mapKeyAttributes;
    private KeyAttributesMap mapMutableKeyAttributes;
    private KeyObligationsMap mapKeyObligations;
    private long issuedServerTimeUtcSeconds;
    private long expirationServerTimeUtcSeconds;

    public KeyVaultKey() {
        this.issuedServerTimeUtcSeconds = 0L;
        this.expirationServerTimeUtcSeconds = 0L;
        this.mapKeyAttributes = new KeyAttributesMap();
        this.mapMutableKeyAttributes = new KeyAttributesMap();
        this.mapKeyObligations = new KeyObligationsMap();
    }

    public KeyVaultKey(AgentKey keyData, long issuedServerTimeUtcSeconds, long expirationServerTimeUtcSeconds) {
        this.keyId = keyData.getId();
        this.keyBytes = keyData.getKey();
        this.mapKeyAttributes = keyData.getAttributesMap();
        this.mapMutableKeyAttributes = keyData.getMutableAttributesMap();
        this.mapKeyObligations = keyData.getObligationsMap();
        this.issuedServerTimeUtcSeconds = issuedServerTimeUtcSeconds;
        this.expirationServerTimeUtcSeconds = expirationServerTimeUtcSeconds;
    }

    public KeyVaultKey(String keyId, byte[] keyBytes, long issuedServerTimeUtcSeconds, long expirationServerTimeUtcSeconds) {
        this.keyId = keyId;
        this.keyBytes = (byte[])keyBytes.clone();
        this.issuedServerTimeUtcSeconds = issuedServerTimeUtcSeconds;
        this.expirationServerTimeUtcSeconds = expirationServerTimeUtcSeconds;
        this.mapKeyAttributes = new KeyAttributesMap();
        this.mapMutableKeyAttributes = new KeyAttributesMap();
        this.mapKeyObligations = new KeyObligationsMap();
    }

    public KeyVaultKey(String keyId, byte[] keyBytes, KeyAttributesMap mapKeyAttributes, KeyAttributesMap mapMutableKeyAttributes, KeyObligationsMap mapKeyObligations, long issuedServerTimeUtcSeconds, long expirationServerTimeUtcSeconds) {
        this.keyId = keyId;
        this.keyBytes = (byte[])keyBytes.clone();
        this.mapKeyAttributes = new KeyAttributesMap(mapKeyAttributes);
        this.mapMutableKeyAttributes = new KeyAttributesMap(mapMutableKeyAttributes);
        this.mapKeyObligations = new KeyObligationsMap(mapKeyObligations);
        this.issuedServerTimeUtcSeconds = issuedServerTimeUtcSeconds;
        this.expirationServerTimeUtcSeconds = expirationServerTimeUtcSeconds;
    }

    KeyVaultKey(KeyVaultKey key) {
        this.keyId = key.keyId;
        this.keyBytes = key.getKeyBytes();
        this.mapKeyAttributes = new KeyAttributesMap(key.getKeyAttributes());
        this.mapMutableKeyAttributes = new KeyAttributesMap(key.getMutableKeyAttributes());
        this.mapKeyObligations = new KeyObligationsMap(key.getKeyObligations());
        this.issuedServerTimeUtcSeconds = key.issuedServerTimeUtcSeconds;
        this.expirationServerTimeUtcSeconds = key.expirationServerTimeUtcSeconds;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) throws NullPointerException {
        this.keyId = Objects.requireNonNull(keyId, "keyId must not be null");
    }

    public byte[] getKeyBytes() {
        return (byte[])this.keyBytes.clone();
    }

    public void setKeyBytes(byte[] keyBytes) {
        this.keyBytes = keyBytes == null ? new byte[]{} : (byte[])keyBytes.clone();
    }

    public KeyAttributesMap getKeyAttributes() {
        return this.mapKeyAttributes;
    }

    public void setKeyAttributes(KeyAttributesMap mapKeyAttributes) {
        this.mapKeyAttributes = mapKeyAttributes == null ? new KeyAttributesMap() : mapKeyAttributes;
    }

    public KeyAttributesMap getMutableKeyAttributes() {
        return this.mapMutableKeyAttributes;
    }

    public void setMutableKeyAttributes(KeyAttributesMap mapMutableKeyAttributes) {
        this.mapMutableKeyAttributes = mapMutableKeyAttributes == null ? new KeyAttributesMap() : mapMutableKeyAttributes;
    }

    public KeyObligationsMap getKeyObligations() {
        return this.mapKeyObligations;
    }

    public void setKeyObligations(KeyObligationsMap mapKeyObligations) {
        this.mapKeyObligations = mapKeyObligations == null ? new KeyObligationsMap() : mapKeyObligations;
    }

    protected void clearAllAttributesAndObligations() {
        this.mapKeyAttributes.clear();
        this.mapMutableKeyAttributes.clear();
        this.mapKeyObligations.clear();
    }

    public long getIssuedServerTimeUtcSeconds() {
        return this.issuedServerTimeUtcSeconds;
    }

    public void setIssuedServerTimeUtcSeconds(long issuedServerTimeUtcSeconds) {
        this.issuedServerTimeUtcSeconds = issuedServerTimeUtcSeconds;
    }

    public long getExpirationServerTimeUtcSeconds() {
        return this.expirationServerTimeUtcSeconds;
    }

    public void setExpirationServerTimeUtcSeconds(long expirationServerTimeUtcSeconds) {
        this.expirationServerTimeUtcSeconds = expirationServerTimeUtcSeconds;
    }

    public boolean isExpired(long currentServerTimeUtcSeconds) {
        if (currentServerTimeUtcSeconds <= 0L) {
            return KeyVaultTimeUtil.getCurrentServerTimeUtcSeconds() >= this.expirationServerTimeUtcSeconds;
        }
        return currentServerTimeUtcSeconds >= this.expirationServerTimeUtcSeconds;
    }

    public boolean isExpired() {
        return KeyVaultTimeUtil.getCurrentServerTimeUtcSeconds() >= this.expirationServerTimeUtcSeconds;
    }

    public boolean equals(Object keyRecObj) {
        if (keyRecObj == this) {
            return true;
        }
        if (!(keyRecObj instanceof KeyVaultKey)) {
            return false;
        }
        KeyVaultKey keyRec = (KeyVaultKey)keyRecObj;
        KeyAttributesMap recAttrMap = keyRec.getKeyAttributes();
        if (this.mapKeyAttributes == null || this.mapKeyAttributes.size() == 0 ? recAttrMap != null && recAttrMap.size() > 0 : recAttrMap == null || !this.mapKeyAttributes.equals(recAttrMap)) {
            return false;
        }
        KeyAttributesMap recMutMap = keyRec.getMutableKeyAttributes();
        if (this.mapMutableKeyAttributes == null || this.mapMutableKeyAttributes.size() == 0 ? recMutMap != null && recMutMap.size() > 0 : recMutMap == null || !this.mapMutableKeyAttributes.equals(recMutMap)) {
            return false;
        }
        KeyObligationsMap recOblMap = keyRec.getKeyObligations();
        if (this.mapKeyObligations == null || this.mapKeyObligations.size() == 0 ? recOblMap != null && recOblMap.size() > 0 : recOblMap == null || !this.mapKeyObligations.equals(recOblMap)) {
            return false;
        }
        return this.keyId.equals(keyRec.getKeyId()) && Arrays.equals(this.keyBytes, keyRec.getKeyBytes()) && this.issuedServerTimeUtcSeconds == keyRec.getIssuedServerTimeUtcSeconds() && this.expirationServerTimeUtcSeconds == keyRec.getExpirationServerTimeUtcSeconds();
    }

    public int hashCode() {
        return Objects.hash(this.keyId, Arrays.hashCode(this.keyBytes), this.mapKeyAttributes, this.mapMutableKeyAttributes, this.mapKeyObligations, this.issuedServerTimeUtcSeconds, this.expirationServerTimeUtcSeconds);
    }
}

