/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.keyvault.impl;

import com.ionic.sdk.cipher.aes.AesGcmCipher;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.crypto.CryptoUtils;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.keyvault.KeyVaultBase;
import com.ionic.sdk.keyvault.KeyVaultEncryptedFile;
import com.ionic.sdk.keyvault.KeyVaultFileModTracker;
import com.ionic.sdk.keyvault.KeyVaultKeyRecord;
import java.io.File;
import java.util.Map;
import java.util.logging.Logger;

public final class KeyVaultPassword
extends KeyVaultBase {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final String VAULT_ID = "keyvault-password";
    private static final String VAULT_LABEL = "Ionic Password Key Vault";
    private static final String IONIC_AUTH_DATA = "Ionic Security Inc";
    private final AesGcmCipher cipher = new AesGcmCipher();
    private String filePath;
    private KeyVaultFileModTracker fileModTracker = null;

    public KeyVaultPassword(String filePath) throws IonicException {
        this.filePath = filePath;
    }

    public void setPassword(String password) throws IonicException {
        int iterations = 2000;
        this.cipher.setKey(CryptoUtils.pbkdf2ToBytes(Transcoder.utf8().decode(password), new byte[0], 2000L, 32L));
        this.cipher.setAuthData(Transcoder.utf8().decode(IONIC_AUTH_DATA));
    }

    @Override
    public String getId() {
        return VAULT_ID;
    }

    @Override
    public String getLabel() {
        return VAULT_LABEL;
    }

    @Override
    public int getSecurityLevel() {
        return 100;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public void cleanVaultStore() {
        this.logger.fine("cleanVaultStore()");
        this.mapKeyRecords.clear();
        try {
            SdkData.checkTrue(this.filePath != null, 80004);
            File outputFile = new File(this.filePath);
            if (!outputFile.delete()) {
                this.logger.info("Failed to delete the vault store file - may not exist yet.");
            }
        }
        catch (Exception e) {
            this.logger.severe(String.format("Exception attempting to delete the vault store file: %s.", e.toString()));
        }
    }

    @Override
    protected Map<String, KeyVaultKeyRecord> loadAllKeyRecords() throws IonicException {
        this.logger.fine("loadAllKeyRecords()");
        SdkData.checkTrue(this.filePath != null, 80004);
        File inputCipherFile = new File(this.filePath);
        if (!inputCipherFile.exists()) {
            throw new IonicException(16016, String.format("No key vault storage file exists at '%s'.", inputCipherFile.getAbsolutePath()));
        }
        if (this.fileModificationPoint(this.filePath) == KeyVaultFileModTracker.Result.FILE_UNCHANGED) {
            throw new IonicException(16013, "File has not changed since last load.");
        }
        KeyVaultEncryptedFile file = new KeyVaultEncryptedFile(VAULT_ID);
        return file.loadAllKeyRecordsFromFile(inputCipherFile.getAbsolutePath(), this.cipher);
    }

    @Override
    protected int saveAllKeyRecords(Map<String, KeyVaultKeyRecord> mapKeyRecords) throws IonicException {
        this.logger.fine("saveAllKeyRecords()");
        SdkData.checkTrue(this.filePath != null, 80004);
        KeyVaultEncryptedFile file = new KeyVaultEncryptedFile(VAULT_ID);
        file.saveAllKeyRecordsToFile(this.cipher, mapKeyRecords, this.filePath);
        this.fileModificationPoint(this.filePath);
        return 0;
    }

    private KeyVaultFileModTracker.Result fileModificationPoint(String filePath) {
        if (this.fileModTracker == null || !this.fileModTracker.getFilePath().equals(filePath)) {
            this.fileModTracker = new KeyVaultFileModTracker(filePath);
        }
        return this.fileModTracker.recordFileInfo();
    }
}

