/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.service.api;

import com.ionic.sdk.agent.config.AgentConfig;
import com.ionic.sdk.core.io.Stream;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.httpclient.HttpClientDefault;
import com.ionic.sdk.httpclient.HttpHeader;
import com.ionic.sdk.httpclient.HttpHeaders;
import com.ionic.sdk.httpclient.HttpRequest;
import com.ionic.sdk.httpclient.HttpResponse;
import com.ionic.sdk.service.api.ServiceVersion;
import java.io.IOException;
import java.net.URL;

public class ServiceQuery {
    private final URL url;

    public ServiceQuery(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public ServiceVersion getVersion() throws IonicException {
        HttpRequest httpRequest = new HttpRequest(this.url, "GET", this.url.getFile(), new HttpHeaders(new HttpHeader[0]), null);
        AgentConfig config = new AgentConfig();
        HttpClientDefault httpClient = new HttpClientDefault(config, this.url.getProtocol());
        try {
            HttpResponse httpResponse = httpClient.execute(httpRequest);
            int statusCode = httpResponse.getStatusCode();
            SdkData.checkTrue(statusCode == 200, 40009);
            String contentType = httpResponse.getHttpHeaders().getHeaderValue("Content-Type");
            SdkData.checkNotNull(contentType, "Content-Type");
            SdkData.checkTrue(contentType.contains("application/json"), 40015);
            return new ServiceVersion(Stream.read(httpResponse.getEntity()));
        }
        catch (IOException e) {
            throw new IonicException(40009, (Throwable)e);
        }
    }
}

