/*
 * Decompiled with CFR 0.152.
 */
package com.ip2proxy;

import com.ip2proxy.ProxyResult;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IP2Proxy {
    private static final Pattern Pattern1 = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    private static final Pattern Pattern2 = Pattern.compile("^([0-9A-F]{1,4}:){6}(0[0-9]+\\.|.*?\\.0[0-9]+).*$", 2);
    private static final Pattern Pattern3 = Pattern.compile("^[0-9]+$");
    private static final Pattern Pattern4 = Pattern.compile("^(.*:)(([0-9]+\\.){3}[0-9]+)$");
    private static final Pattern Pattern5 = Pattern.compile("^.*((:[0-9A-F]{1,4}){2})$");
    private static final Pattern Pattern6 = Pattern.compile("^[0:]+((:[0-9A-F]{1,4}){1,2})$", 2);
    private static final Pattern Pattern7 = Pattern.compile("^([0-9]+\\.){1,2}[0-9]+$");
    private static final BigInteger MAX_IPV4_RANGE = new BigInteger("4294967295");
    private static final BigInteger MAX_IPV6_RANGE = new BigInteger("340282366920938463463374607431768211455");
    private static final String MSG_NOT_SUPPORTED = "NOT SUPPORTED";
    private static final String MSG_INVALID_IP = "INVALID IP ADDRESS";
    private static final String MSG_MISSING_FILE = "MISSING FILE";
    private static final String MSG_IPV6_UNSUPPORTED = "IPV6 ADDRESS MISSING IN IPV4 BIN";
    private static final int[] COUNTRY_POSITION = new int[]{0, 2, 3, 3, 3};
    private static final int[] REGION_POSITION = new int[]{0, 0, 0, 4, 4};
    private static final int[] CITY_POSITION = new int[]{0, 0, 0, 5, 5};
    private static final int[] ISP_POSITION = new int[]{0, 0, 0, 0, 6};
    private static final int[] PROXYTYPE_POSITION = new int[]{0, 0, 2, 2, 2};
    private MappedByteBuffer _IPv4Buffer = null;
    private MappedByteBuffer _IPv6Buffer = null;
    private MappedByteBuffer _MapDataBuffer = null;
    private int[][] _IndexArrayIPv4 = new int[65536][2];
    private int[][] _IndexArrayIPv6 = new int[65536][2];
    private long _IPv4Offset = 0L;
    private long _IPv6Offset = 0L;
    private long _MapDataOffset = 0L;
    private int _IPv4ColumnSize = 0;
    private int _IPv6ColumnSize = 0;
    private int _BaseAddr = 0;
    private int _DBCount = 0;
    private int _DBColumn = 0;
    private int _DBType = 0;
    private int _DBDay = 1;
    private int _DBMonth = 1;
    private int _DBYear = 1;
    private int _BaseAddrIPv6 = 0;
    private int _DBCountIPv6 = 0;
    private int _IndexBaseAddr = 0;
    private int _IndexBaseAddrIPv6 = 0;
    private boolean _UseMemoryMappedFile = false;
    private String _IPDatabasePath = "";
    private int COUNTRY_POSITION_OFFSET;
    private int REGION_POSITION_OFFSET;
    private int CITY_POSITION_OFFSET;
    private int ISP_POSITION_OFFSET;
    private int PROXYTYPE_POSITION_OFFSET;
    private boolean COUNTRY_ENABLED;
    private boolean REGION_ENABLED;
    private boolean CITY_ENABLED;
    private boolean ISP_ENABLED;
    private boolean PROXYTYPE_ENABLED;
    private static final String _ModuleVersion = "1.0.1";

    public String GetModuleVersion() {
        return _ModuleVersion;
    }

    public String GetPackageVersion() {
        return String.valueOf(this._DBType);
    }

    public String GetDatabaseVersion() {
        if (this._DBYear == 0) {
            return "";
        }
        return "20" + String.valueOf(this._DBYear) + "." + String.valueOf(this._DBMonth) + "." + String.valueOf(this._DBDay);
    }

    public int IsProxy(String IP) throws IOException {
        return this.ProxyQuery((String)IP, (Modes)Modes.IS_PROXY).Is_Proxy;
    }

    public String GetCountryShort(String IP) throws IOException {
        return this.ProxyQuery((String)IP, (Modes)Modes.COUNTRY_SHORT).Country_Short;
    }

    public String GetCountryLong(String IP) throws IOException {
        return this.ProxyQuery((String)IP, (Modes)Modes.COUNTRY_LONG).Country_Long;
    }

    public String GetRegion(String IP) throws IOException {
        return this.ProxyQuery((String)IP, (Modes)Modes.REGION).Region;
    }

    public String GetCity(String IP) throws IOException {
        return this.ProxyQuery((String)IP, (Modes)Modes.CITY).City;
    }

    public String GetISP(String IP) throws IOException {
        return this.ProxyQuery((String)IP, (Modes)Modes.ISP).ISP;
    }

    public String GetProxyType(String IP) throws IOException {
        return this.ProxyQuery((String)IP, (Modes)Modes.PROXY_TYPE).Proxy_Type;
    }

    public ProxyResult GetAll(String IP) throws IOException {
        return this.ProxyQuery(IP);
    }

    public int Close() {
        this.DestroyMappedBytes();
        this._BaseAddr = 0;
        this._DBCount = 0;
        this._DBColumn = 0;
        this._DBType = 0;
        this._DBDay = 1;
        this._DBMonth = 1;
        this._DBYear = 1;
        this._BaseAddrIPv6 = 0;
        this._DBCountIPv6 = 0;
        this._IndexBaseAddr = 0;
        this._IndexBaseAddrIPv6 = 0;
        return 0;
    }

    private void DestroyMappedBytes() {
        if (this._IPv4Buffer != null) {
            this._IPv4Buffer = null;
        }
        if (this._IPv6Buffer != null) {
            this._IPv6Buffer = null;
        }
        if (this._MapDataBuffer != null) {
            this._MapDataBuffer = null;
        }
    }

    private void CreateMappedBytes() throws IOException {
        RandomAccessFile RF = null;
        try {
            RF = new RandomAccessFile(this._IPDatabasePath, "r");
            FileChannel InChannel = RF.getChannel();
            this.CreateMappedBytes(InChannel);
        }
        catch (IOException Ex) {
            throw Ex;
        }
        finally {
            if (RF != null) {
                RF.close();
                RF = null;
            }
        }
    }

    private void CreateMappedBytes(FileChannel InChannel) throws IOException {
        if (this._IPv4Buffer == null) {
            long _IPv4Bytes = (long)this._IPv4ColumnSize * (long)this._DBCount;
            this._IPv4Offset = this._BaseAddr - 1;
            this._IPv4Buffer = InChannel.map(FileChannel.MapMode.READ_ONLY, this._IPv4Offset, _IPv4Bytes);
            this._IPv4Buffer.order(ByteOrder.LITTLE_ENDIAN);
            this._MapDataOffset = this._IPv4Offset + _IPv4Bytes;
        }
        if (this._DBCountIPv6 > 0 && this._IPv6Buffer == null) {
            long _IPv6Bytes = (long)this._IPv6ColumnSize * (long)this._DBCountIPv6;
            this._IPv6Offset = this._BaseAddrIPv6 - 1;
            this._IPv6Buffer = InChannel.map(FileChannel.MapMode.READ_ONLY, this._IPv6Offset, _IPv6Bytes);
            this._IPv6Buffer.order(ByteOrder.LITTLE_ENDIAN);
            this._MapDataOffset = this._IPv6Offset + _IPv6Bytes;
        }
        if (this._MapDataBuffer == null) {
            this._MapDataBuffer = InChannel.map(FileChannel.MapMode.READ_ONLY, this._MapDataOffset, InChannel.size() - this._MapDataOffset);
            this._MapDataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    private boolean LoadBIN() throws IOException {
        boolean LoadOK = false;
        RandomAccessFile RF = null;
        try {
            if (this._IPDatabasePath.length() > 0) {
                int x;
                RF = new RandomAccessFile(this._IPDatabasePath, "r");
                FileChannel InChannel = RF.getChannel();
                MappedByteBuffer _HeaderBuffer = InChannel.map(FileChannel.MapMode.READ_ONLY, 0L, 64L);
                _HeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this._DBType = _HeaderBuffer.get(0);
                this._DBColumn = _HeaderBuffer.get(1);
                this._DBYear = _HeaderBuffer.get(2);
                this._DBMonth = _HeaderBuffer.get(3);
                this._DBDay = _HeaderBuffer.get(4);
                this._DBCount = _HeaderBuffer.getInt(5);
                this._BaseAddr = _HeaderBuffer.getInt(9);
                this._DBCountIPv6 = _HeaderBuffer.getInt(13);
                this._BaseAddrIPv6 = _HeaderBuffer.getInt(17);
                this._IndexBaseAddr = _HeaderBuffer.getInt(21);
                this._IndexBaseAddrIPv6 = _HeaderBuffer.getInt(25);
                this._IPv4ColumnSize = this._DBColumn << 2;
                this._IPv6ColumnSize = 16 + (this._DBColumn - 1 << 2);
                this.COUNTRY_POSITION_OFFSET = COUNTRY_POSITION[this._DBType] != 0 ? COUNTRY_POSITION[this._DBType] - 1 << 2 : 0;
                this.REGION_POSITION_OFFSET = REGION_POSITION[this._DBType] != 0 ? REGION_POSITION[this._DBType] - 1 << 2 : 0;
                this.CITY_POSITION_OFFSET = CITY_POSITION[this._DBType] != 0 ? CITY_POSITION[this._DBType] - 1 << 2 : 0;
                this.ISP_POSITION_OFFSET = ISP_POSITION[this._DBType] != 0 ? ISP_POSITION[this._DBType] - 1 << 2 : 0;
                this.PROXYTYPE_POSITION_OFFSET = PROXYTYPE_POSITION[this._DBType] != 0 ? PROXYTYPE_POSITION[this._DBType] - 1 << 2 : 0;
                this.COUNTRY_ENABLED = COUNTRY_POSITION[this._DBType] != 0;
                this.REGION_ENABLED = REGION_POSITION[this._DBType] != 0;
                this.CITY_ENABLED = CITY_POSITION[this._DBType] != 0;
                this.ISP_ENABLED = ISP_POSITION[this._DBType] != 0;
                this.PROXYTYPE_ENABLED = PROXYTYPE_POSITION[this._DBType] != 0;
                MappedByteBuffer _IndexBuffer = InChannel.map(FileChannel.MapMode.READ_ONLY, this._IndexBaseAddr - 1, this._BaseAddr - this._IndexBaseAddr);
                _IndexBuffer.order(ByteOrder.LITTLE_ENDIAN);
                int Pointer = 0;
                for (x = 0; x < this._IndexArrayIPv4.length; ++x) {
                    this._IndexArrayIPv4[x][0] = _IndexBuffer.getInt(Pointer);
                    this._IndexArrayIPv4[x][1] = _IndexBuffer.getInt(Pointer + 4);
                    Pointer += 8;
                }
                if (this._IndexBaseAddrIPv6 > 0) {
                    for (x = 0; x < this._IndexArrayIPv6.length; ++x) {
                        this._IndexArrayIPv6[x][0] = _IndexBuffer.getInt(Pointer);
                        this._IndexArrayIPv6[x][1] = _IndexBuffer.getInt(Pointer + 4);
                        Pointer += 8;
                    }
                }
                if (this._UseMemoryMappedFile) {
                    this.CreateMappedBytes(InChannel);
                } else {
                    this.DestroyMappedBytes();
                }
                LoadOK = true;
            }
        }
        catch (IOException Ex) {
            throw Ex;
        }
        finally {
            if (RF != null) {
                RF.close();
                RF = null;
            }
        }
        return LoadOK;
    }

    public int Open(String DatabasePath) throws IOException {
        return this.Open(DatabasePath, IOModes.IP2PROXY_FILE_IO);
    }

    public int Open(String DatabasePath, IOModes IOMode) throws IOException {
        if (this._DBType == 0) {
            this._IPDatabasePath = DatabasePath;
            if (IOMode == IOModes.IP2PROXY_MEMORY_MAPPED) {
                this._UseMemoryMappedFile = true;
            }
            if (!this.LoadBIN()) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    public ProxyResult ProxyQuery(String IPAddress) throws IOException {
        return this.ProxyQuery(IPAddress, Modes.ALL);
    }

    public ProxyResult ProxyQuery(String IPAddress, Modes Mode) throws IOException {
        ProxyResult Result = new ProxyResult();
        RandomAccessFile RF = null;
        MappedByteBuffer Buf = null;
        try {
            BigInteger IPNo;
            if (IPAddress == null || IPAddress.length() == 0) {
                Result.Is_Proxy = -1;
                Result.Proxy_Type = MSG_INVALID_IP;
                Result.Country_Short = MSG_INVALID_IP;
                Result.Country_Long = MSG_INVALID_IP;
                Result.Region = MSG_INVALID_IP;
                Result.City = MSG_INVALID_IP;
                Result.ISP = MSG_INVALID_IP;
                ProxyResult proxyResult = Result;
                return proxyResult;
            }
            int IndexAddr = 0;
            int ActualIPType = 0;
            int IPType = 0;
            boolean DBType = false;
            int BaseAddr = 0;
            boolean DBColumn = false;
            int ColumnSize = 0;
            int BufCapacity = 0;
            BigInteger MAX_IP_RANGE = BigInteger.ZERO;
            long RowOffset = 0L;
            long RowOffset2 = 0L;
            boolean OverCapacity = false;
            try {
                BigInteger[] BI = this.IP2No(IPAddress);
                IPType = BI[0].intValue();
                IPNo = BI[1];
                ActualIPType = BI[2].intValue();
                if (ActualIPType == 6) {
                    String[] RetArr = this.ExpandIPv6(IPAddress, IPType);
                    IPType = Integer.parseInt(RetArr[1]);
                }
            }
            catch (UnknownHostException Ex) {
                Result.Is_Proxy = -1;
                Result.Proxy_Type = MSG_INVALID_IP;
                Result.Country_Short = MSG_INVALID_IP;
                Result.Country_Long = MSG_INVALID_IP;
                Result.Region = MSG_INVALID_IP;
                Result.City = MSG_INVALID_IP;
                Result.ISP = MSG_INVALID_IP;
                ProxyResult proxyResult = Result;
                if (RF != null) {
                    RF.close();
                    RF = null;
                }
                return proxyResult;
            }
            long CountryPos = 0L;
            long Low = 0L;
            long High = 0L;
            long Mid = 0L;
            BigInteger IPFrom = BigInteger.ZERO;
            BigInteger IPTo = BigInteger.ZERO;
            if (this._DBType == 0 && !this.LoadBIN()) {
                Result.Is_Proxy = -1;
                Result.Proxy_Type = MSG_MISSING_FILE;
                Result.Country_Short = MSG_MISSING_FILE;
                Result.Country_Long = MSG_MISSING_FILE;
                Result.Region = MSG_MISSING_FILE;
                Result.City = MSG_MISSING_FILE;
                Result.ISP = MSG_MISSING_FILE;
                ProxyResult proxyResult = Result;
                return proxyResult;
            }
            if (this._UseMemoryMappedFile) {
                if (this._IPv4Buffer == null || this._DBCountIPv6 > 0 && this._IPv6Buffer == null || this._MapDataBuffer == null) {
                    this.CreateMappedBytes();
                }
            } else {
                this.DestroyMappedBytes();
                RF = new RandomAccessFile(this._IPDatabasePath, "r");
            }
            if (IPType == 4) {
                MAX_IP_RANGE = MAX_IPV4_RANGE;
                High = this._DBCount;
                if (this._UseMemoryMappedFile) {
                    Buf = this._IPv4Buffer;
                    BufCapacity = Buf.capacity();
                } else {
                    BaseAddr = this._BaseAddr;
                }
                ColumnSize = this._IPv4ColumnSize;
                IndexAddr = IPNo.shiftRight(16).intValue();
                Low = this._IndexArrayIPv4[IndexAddr][0];
                High = this._IndexArrayIPv4[IndexAddr][1];
            } else {
                if (this._DBCountIPv6 == 0) {
                    Result.Is_Proxy = -1;
                    Result.Proxy_Type = MSG_IPV6_UNSUPPORTED;
                    Result.Country_Short = MSG_IPV6_UNSUPPORTED;
                    Result.Country_Long = MSG_IPV6_UNSUPPORTED;
                    Result.Region = MSG_IPV6_UNSUPPORTED;
                    Result.City = MSG_IPV6_UNSUPPORTED;
                    Result.ISP = MSG_IPV6_UNSUPPORTED;
                    ProxyResult proxyResult = Result;
                    return proxyResult;
                }
                MAX_IP_RANGE = MAX_IPV6_RANGE;
                High = this._DBCountIPv6;
                if (this._UseMemoryMappedFile) {
                    Buf = this._IPv6Buffer;
                    BufCapacity = Buf.capacity();
                } else {
                    BaseAddr = this._BaseAddrIPv6;
                }
                ColumnSize = this._IPv6ColumnSize;
                if (this._IndexBaseAddrIPv6 > 0) {
                    IndexAddr = IPNo.shiftRight(112).intValue();
                    Low = this._IndexArrayIPv6[IndexAddr][0];
                    High = this._IndexArrayIPv6[IndexAddr][1];
                }
            }
            if (IPNo.compareTo(MAX_IP_RANGE) == 0) {
                IPNo = IPNo.subtract(BigInteger.ONE);
            }
            while (Low <= High) {
                Mid = (Low + High) / 2L;
                RowOffset = (long)BaseAddr + Mid * (long)ColumnSize;
                RowOffset2 = RowOffset + (long)ColumnSize;
                if (this._UseMemoryMappedFile) {
                    OverCapacity = RowOffset2 >= (long)BufCapacity;
                }
                IPFrom = this.Read32Or128(RowOffset, IPType, Buf, RF);
                BigInteger bigInteger = IPTo = OverCapacity ? BigInteger.ZERO : this.Read32Or128(RowOffset2, IPType, Buf, RF);
                if (IPNo.compareTo(IPFrom) >= 0 && IPNo.compareTo(IPTo) < 0) {
                    int Is_Proxy = -1;
                    String Proxy_Type = MSG_NOT_SUPPORTED;
                    String Country_Short = MSG_NOT_SUPPORTED;
                    String Country_Long = MSG_NOT_SUPPORTED;
                    String Region = MSG_NOT_SUPPORTED;
                    String City = MSG_NOT_SUPPORTED;
                    String ISP = MSG_NOT_SUPPORTED;
                    if (IPType == 6) {
                        RowOffset += 12L;
                    }
                    if (this.PROXYTYPE_ENABLED && (Mode == Modes.ALL || Mode == Modes.PROXY_TYPE || Mode == Modes.IS_PROXY)) {
                        Proxy_Type = this.ReadStr(this.Read32(RowOffset + (long)this.PROXYTYPE_POSITION_OFFSET, Buf, RF).longValue(), RF);
                    }
                    if (this.COUNTRY_ENABLED) {
                        if (Mode == Modes.ALL || Mode == Modes.COUNTRY_SHORT || Mode == Modes.COUNTRY_LONG || Mode == Modes.IS_PROXY) {
                            CountryPos = this.Read32(RowOffset + (long)this.COUNTRY_POSITION_OFFSET, Buf, RF).longValue();
                        }
                        if (Mode == Modes.ALL || Mode == Modes.COUNTRY_SHORT || Mode == Modes.IS_PROXY) {
                            Country_Short = this.ReadStr(CountryPos, RF);
                        }
                        if (Mode == Modes.ALL || Mode == Modes.COUNTRY_LONG) {
                            Country_Long = this.ReadStr(CountryPos + 3L, RF);
                        }
                    }
                    if (this.REGION_ENABLED && (Mode == Modes.ALL || Mode == Modes.REGION)) {
                        Region = this.ReadStr(this.Read32(RowOffset + (long)this.REGION_POSITION_OFFSET, Buf, RF).longValue(), RF);
                    }
                    if (this.CITY_ENABLED && (Mode == Modes.ALL || Mode == Modes.CITY)) {
                        City = this.ReadStr(this.Read32(RowOffset + (long)this.CITY_POSITION_OFFSET, Buf, RF).longValue(), RF);
                    }
                    if (this.ISP_ENABLED && (Mode == Modes.ALL || Mode == Modes.ISP)) {
                        ISP = this.ReadStr(this.Read32(RowOffset + (long)this.ISP_POSITION_OFFSET, Buf, RF).longValue(), RF);
                    }
                    Is_Proxy = Country_Short.equals("-") || Proxy_Type.equals("-") ? 0 : (Proxy_Type.equals("DCH") ? 2 : 1);
                    Result.Is_Proxy = Is_Proxy;
                    Result.Proxy_Type = Proxy_Type;
                    Result.Country_Short = Country_Short;
                    Result.Country_Long = Country_Long;
                    Result.Region = Region;
                    Result.City = City;
                    Result.ISP = ISP;
                    ProxyResult proxyResult = Result;
                    return proxyResult;
                }
                if (IPNo.compareTo(IPFrom) < 0) {
                    High = Mid - 1L;
                    continue;
                }
                Low = Mid + 1L;
            }
            Result.Is_Proxy = -1;
            Result.Proxy_Type = MSG_INVALID_IP;
            Result.Country_Short = MSG_INVALID_IP;
            Result.Country_Long = MSG_INVALID_IP;
            Result.Region = MSG_INVALID_IP;
            Result.City = MSG_INVALID_IP;
            Result.ISP = MSG_INVALID_IP;
            ProxyResult proxyResult = Result;
            return proxyResult;
        }
        catch (IOException Ex) {
            throw Ex;
        }
        finally {
            if (RF != null) {
                RF.close();
                RF = null;
            }
        }
    }

    private String[] ExpandIPv6(String IP, int IPType) {
        Matcher Mat;
        String Tmp = "0000:0000:0000:0000:0000:";
        String PadMe = "0000";
        long HexOffset = 255L;
        String IP2 = IP.toUpperCase();
        String RetType = String.valueOf(IPType);
        if (IPType == 4) {
            if (Pattern4.matcher(IP2).matches()) {
                IP2 = IP2.replaceAll("::", "0000:0000:0000:0000:0000:");
            } else {
                Mat = Pattern5.matcher(IP2);
                if (Mat.matches()) {
                    String Match = Mat.group(1);
                    String[] Arr = Match.replaceAll("^:+", "").replaceAll(":+$", "").split(":");
                    int Len = Arr.length;
                    StringBuilder Bf = new StringBuilder(32);
                    for (int x = 0; x < Len; ++x) {
                        String Unpadded = Arr[x];
                        Bf.append("0000".substring(Unpadded.length()) + Unpadded);
                    }
                    long Tmp2 = new BigInteger(Bf.toString(), 16).longValue();
                    long[] Bytes = new long[]{0L, 0L, 0L, 0L};
                    for (int x = 0; x < 4; ++x) {
                        Bytes[x] = Tmp2 & 0xFFL;
                        Tmp2 >>= 8;
                    }
                    IP2 = IP2.replaceAll(Match + "$", ":" + Bytes[3] + "." + Bytes[2] + "." + Bytes[1] + "." + Bytes[0]);
                    IP2 = IP2.replaceAll("::", "0000:0000:0000:0000:0000:");
                }
            }
        } else if (IPType == 6) {
            if (IP2.equals("::")) {
                IP2 = IP2 + "0.0.0.0";
                IP2 = IP2.replaceAll("::", "0000:0000:0000:0000:0000:FFFF:");
                RetType = "4";
            } else {
                Mat = Pattern4.matcher(IP2);
                if (Mat.matches()) {
                    int TotalSegmentsLeft;
                    int x;
                    String V6Part = Mat.group(1);
                    String V4Part = Mat.group(2);
                    String[] V4Arr = V4Part.split("\\.");
                    int[] V4IntArr = new int[4];
                    int Len = V4IntArr.length;
                    for (int x2 = 0; x2 < Len; ++x2) {
                        V4IntArr[x2] = Integer.parseInt(V4Arr[x2]);
                    }
                    int Part1 = (V4IntArr[0] << 8) + V4IntArr[1];
                    int Part2 = (V4IntArr[2] << 8) + V4IntArr[3];
                    String Part1Hex = Integer.toHexString(Part1);
                    String Part2Hex = Integer.toHexString(Part2);
                    StringBuilder Bf = new StringBuilder(V6Part.length() + 9);
                    Bf.append(V6Part);
                    Bf.append("0000".substring(Part1Hex.length()));
                    Bf.append(Part1Hex);
                    Bf.append(":");
                    Bf.append("0000".substring(Part2Hex.length()));
                    Bf.append(Part2Hex);
                    IP2 = Bf.toString().toUpperCase();
                    String[] Arr = IP2.split("::");
                    String[] LeftSide = Arr[0].split(":");
                    StringBuilder Bf2 = new StringBuilder(40);
                    StringBuilder Bf3 = new StringBuilder(40);
                    StringBuilder Bf4 = new StringBuilder(40);
                    Len = LeftSide.length;
                    int TotalSegments = 0;
                    for (int x3 = 0; x3 < Len; ++x3) {
                        if (LeftSide[x3].length() <= 0) continue;
                        ++TotalSegments;
                        Bf2.append("0000".substring(LeftSide[x3].length()));
                        Bf2.append(LeftSide[x3]);
                        Bf2.append(":");
                    }
                    if (Arr.length > 1) {
                        String[] RightSide = Arr[1].split(":");
                        Len = RightSide.length;
                        for (x = 0; x < Len; ++x) {
                            if (RightSide[x].length() <= 0) continue;
                            ++TotalSegments;
                            Bf3.append("0000".substring(RightSide[x].length()));
                            Bf3.append(RightSide[x]);
                            Bf3.append(":");
                        }
                    }
                    if ((TotalSegmentsLeft = 8 - TotalSegments) == 6) {
                        for (x = 1; x < TotalSegmentsLeft; ++x) {
                            Bf4.append("0000");
                            Bf4.append(":");
                        }
                        Bf4.append("FFFF:");
                        Bf4.append(V4Part);
                        RetType = "4";
                        IP2 = Bf4.toString();
                    } else {
                        for (x = 0; x < TotalSegmentsLeft; ++x) {
                            Bf4.append("0000");
                            Bf4.append(":");
                        }
                        Bf2.append((CharSequence)Bf4).append((CharSequence)Bf3);
                        IP2 = Bf2.toString().replaceAll(":$", "");
                    }
                } else {
                    Matcher Mat2 = Pattern6.matcher(IP2);
                    if (Mat2.matches()) {
                        String Match = Mat2.group(1);
                        String[] Arr = Match.replaceAll("^:+", "").replaceAll(":+$", "").split(":");
                        int Len = Arr.length;
                        StringBuilder Bf = new StringBuilder(32);
                        for (int x = 0; x < Len; ++x) {
                            String Unpadded = Arr[x];
                            Bf.append("0000".substring(Unpadded.length()) + Unpadded);
                        }
                        long Tmp2 = new BigInteger(Bf.toString(), 16).longValue();
                        long[] Bytes = new long[]{0L, 0L, 0L, 0L};
                        for (int x = 0; x < 4; ++x) {
                            Bytes[x] = Tmp2 & 0xFFL;
                            Tmp2 >>= 8;
                        }
                        IP2 = IP2.replaceAll(Match + "$", ":" + Bytes[3] + "." + Bytes[2] + "." + Bytes[1] + "." + Bytes[0]);
                        IP2 = IP2.replaceAll("::", "0000:0000:0000:0000:0000:FFFF:");
                        RetType = "4";
                    } else {
                        int x;
                        String[] Arr = IP2.split("::");
                        String[] LeftSide = Arr[0].split(":");
                        StringBuilder Bf2 = new StringBuilder(40);
                        StringBuilder Bf3 = new StringBuilder(40);
                        StringBuilder Bf4 = new StringBuilder(40);
                        int Len = LeftSide.length;
                        int TotalSegments = 0;
                        for (int x4 = 0; x4 < Len; ++x4) {
                            if (LeftSide[x4].length() <= 0) continue;
                            ++TotalSegments;
                            Bf2.append("0000".substring(LeftSide[x4].length()));
                            Bf2.append(LeftSide[x4]);
                            Bf2.append(":");
                        }
                        if (Arr.length > 1) {
                            String[] RightSide = Arr[1].split(":");
                            Len = RightSide.length;
                            for (x = 0; x < Len; ++x) {
                                if (RightSide[x].length() <= 0) continue;
                                ++TotalSegments;
                                Bf3.append("0000".substring(RightSide[x].length()));
                                Bf3.append(RightSide[x]);
                                Bf3.append(":");
                            }
                        }
                        int TotalSegmentsLeft = 8 - TotalSegments;
                        for (x = 0; x < TotalSegmentsLeft; ++x) {
                            Bf4.append("0000");
                            Bf4.append(":");
                        }
                        Bf2.append((CharSequence)Bf4).append((CharSequence)Bf3);
                        IP2 = Bf2.toString().replaceAll(":$", "");
                    }
                }
            }
        }
        String[] RetArr = new String[]{IP2, RetType};
        return RetArr;
    }

    private void Reverse(byte[] Arr) {
        if (Arr == null) {
            return;
        }
        int i = 0;
        for (int j = Arr.length - 1; j > i; --j, ++i) {
            byte tmp = Arr[j];
            Arr[j] = Arr[i];
            Arr[i] = tmp;
        }
    }

    private BigInteger Read32Or128(long Position, int IPType, MappedByteBuffer Buf, RandomAccessFile RH) throws IOException {
        if (IPType == 4) {
            return this.Read32(Position, Buf, RH);
        }
        if (IPType == 6) {
            return this.Read128(Position, Buf, RH);
        }
        return BigInteger.ZERO;
    }

    private BigInteger Read128(long Position, MappedByteBuffer Buf, RandomAccessFile RH) throws IOException {
        BigInteger RetVal = BigInteger.ZERO;
        int BSize = 16;
        byte[] Bytes = new byte[16];
        if (this._UseMemoryMappedFile) {
            for (int x = 0; x < 16; ++x) {
                Bytes[x] = Buf.get((int)Position + x);
            }
        } else {
            RH.seek(Position - 1L);
            for (int x = 0; x < 16; ++x) {
                Bytes[x] = RH.readByte();
            }
        }
        this.Reverse(Bytes);
        RetVal = new BigInteger(1, Bytes);
        return RetVal;
    }

    private BigInteger Read32(long Position, MappedByteBuffer Buf, RandomAccessFile RH) throws IOException {
        if (this._UseMemoryMappedFile) {
            return BigInteger.valueOf((long)Buf.getInt((int)Position) & 0xFFFFFFFFL);
        }
        int BSize = 4;
        RH.seek(Position - 1L);
        byte[] Bytes = new byte[4];
        for (int x = 0; x < 4; ++x) {
            Bytes[x] = RH.readByte();
        }
        this.Reverse(Bytes);
        return new BigInteger(1, Bytes);
    }

    private String ReadStr(long Position, RandomAccessFile RH) throws IOException {
        char[] CBuf = null;
        if (this._UseMemoryMappedFile) {
            int Size = this._MapDataBuffer.get((int)(Position -= this._MapDataOffset));
            try {
                CBuf = new char[Size];
                for (int x = 0; x < Size; ++x) {
                    CBuf[x] = (char)this._MapDataBuffer.get((int)Position + 1 + x);
                }
            }
            catch (NegativeArraySizeException e) {
                return null;
            }
        }
        RH.seek(Position);
        int Size = RH.read();
        try {
            CBuf = new char[Size];
            for (int x = 0; x < Size; ++x) {
                CBuf[x] = (char)RH.read();
            }
        }
        catch (NegativeArraySizeException e) {
            return null;
        }
        return String.copyValueOf(CBuf);
    }

    private BigInteger[] IP2No(String IP) throws UnknownHostException {
        BigInteger A1 = BigInteger.ZERO;
        BigInteger A2 = BigInteger.ZERO;
        BigInteger A3 = new BigInteger("4");
        if (Pattern1.matcher(IP).matches()) {
            A1 = new BigInteger("4");
            A2 = new BigInteger(String.valueOf(this.IPv4No(IP)));
        } else {
            if (Pattern2.matcher(IP).matches() || Pattern3.matcher(IP).matches() || Pattern7.matcher(IP).matches()) {
                throw new UnknownHostException();
            }
            A3 = new BigInteger("6");
            InetAddress IA = InetAddress.getByName(IP);
            byte[] Bytes = IA.getAddress();
            String IPType = "0";
            if (IA instanceof Inet6Address) {
                IPType = "6";
            } else if (IA instanceof Inet4Address) {
                IPType = "4";
            }
            A1 = new BigInteger(IPType);
            A2 = new BigInteger(1, Bytes);
        }
        BigInteger[] BI = new BigInteger[]{A1, A2, A3};
        return BI;
    }

    private long IPv4No(String IP) {
        String[] IPs = IP.split("\\.");
        long RetVal = 0L;
        long IPLong = 0L;
        for (int x = 3; x >= 0; --x) {
            IPLong = Long.parseLong(IPs[3 - x]);
            RetVal |= IPLong << (x << 3);
        }
        return RetVal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Modes {
        COUNTRY_SHORT,
        COUNTRY_LONG,
        REGION,
        CITY,
        ISP,
        PROXY_TYPE,
        IS_PROXY,
        ALL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IOModes {
        IP2PROXY_FILE_IO,
        IP2PROXY_MEMORY_MAPPED;

    }
}

