/*
 * Decompiled with CFR 0.152.
 */
package com.ip2proxy;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ip2proxy.Http;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Pattern;

public class IP2ProxyWebService {
    private static final Pattern pattern = Pattern.compile("^[\\dA-Z]{10}$");
    private static final Pattern pattern2 = Pattern.compile("^PX\\d+$");
    private String _APIKey = "";
    private String _Package = "";
    private boolean _UseSSL = true;

    public void Open(String APIKey, String Package) throws IllegalArgumentException {
        this.Open(APIKey, Package, true);
    }

    public void Open(String APIKey, String Package, boolean UseSSL) throws IllegalArgumentException {
        this._APIKey = APIKey;
        this._Package = Package;
        this._UseSSL = UseSSL;
        this.CheckParams();
    }

    private void CheckParams() throws IllegalArgumentException {
        if (!pattern.matcher(this._APIKey).matches() && !this._APIKey.equals("demo")) {
            throw new IllegalArgumentException("Invalid API key.");
        }
        if (!pattern2.matcher(this._Package).matches()) {
            throw new IllegalArgumentException("Invalid package name.");
        }
    }

    public JsonObject IPQuery(String IPAddress) throws IllegalArgumentException, RuntimeException {
        try {
            this.CheckParams();
            StringBuffer bf = new StringBuffer();
            bf.append("http");
            if (this._UseSSL) {
                bf.append("s");
            }
            bf.append("://api.ip2proxy.com/?key=").append(this._APIKey).append("&package=").append(this._Package).append("&ip=").append(URLEncoder.encode(IPAddress, "UTF-8"));
            String myurl = bf.toString();
            String myjson = Http.get(new URL(myurl));
            JsonParser parser = new JsonParser();
            JsonObject myresult = parser.parse(myjson).getAsJsonObject();
            return myresult;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public JsonObject GetCredit() throws IllegalArgumentException, RuntimeException {
        try {
            this.CheckParams();
            StringBuffer bf = new StringBuffer();
            bf.append("http");
            if (this._UseSSL) {
                bf.append("s");
            }
            bf.append("://api.ip2proxy.com/?key=").append(this._APIKey).append("&check=true");
            String myurl = bf.toString();
            String myjson = Http.get(new URL(myurl));
            JsonParser parser = new JsonParser();
            JsonObject myresult = parser.parse(myjson).getAsJsonObject();
            return myresult;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception ex2) {
            throw new RuntimeException(ex2);
        }
    }
}

