/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client;

import com.google.auto.service.AutoService;
import com.jacobmountain.graphql.client.ClientGenerator;
import com.jacobmountain.graphql.client.DTOGenerator;
import com.jacobmountain.graphql.client.FileWriter;
import com.jacobmountain.graphql.client.TypeMapper;
import com.jacobmountain.graphql.client.annotations.GraphQLClient;
import com.jacobmountain.graphql.client.exceptions.SchemaNotFoundException;
import com.jacobmountain.graphql.client.utils.Schema;
import com.jacobmountain.graphql.client.utils.StringUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"com.jacobmountain.graphql.client.*"})
@AutoService(value={Processor.class})
public class GraphQLClientProcessor
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger(GraphQLClientProcessor.class);
    private Filer filer;
    private Messager messager;
    private Path root;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(GraphQLClient.class);
        for (Element element : elements) {
            if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE) continue;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't be applied to class");
            return true;
        }
        return elements.stream().map(el -> (TypeElement)el).map(x$0 -> new Input((TypeElement)x$0)).peek(this.generateJavaDataClasses()).peek(this::generateClientImplementation).count() > 0L;
    }

    private Consumer<Input> generateJavaDataClasses() {
        return input -> {
            log.info("Generating java classes from GraphQL schema");
            DTOGenerator dtoGenerator = new DTOGenerator(input.getDtoPackage(), new FileWriter(this.filer), input.getTypeMapper());
            dtoGenerator.generate(input.getSchema().types().values());
            dtoGenerator.generateArgumentDTOs(((Input)input).element);
        };
    }

    private void generateClientImplementation(Input client) {
        GraphQLClient annotation = client.getAnnotation();
        log.info("Generating java implementation of {}", (Object)client.element.getSimpleName());
        new ClientGenerator(this.filer, annotation.maxDepth(), client.getTypeMapper(), client.getPackage(), client.getDtoPackage(), client.getSchema(), annotation.reactive()).generate(client.element, annotation.implSuffix());
    }

    private Path getRoot() {
        if (this.root == null) {
            FileObject resource = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", "tmp", null);
            this.root = Paths.get(resource.toUri()).getParent().getParent().getParent().getParent().getParent();
            resource.delete();
        }
        return this.root;
    }

    private final class Input {
        private final TypeElement element;

        GraphQLClient getAnnotation() {
            return this.element.getAnnotation(GraphQLClient.class);
        }

        TypeMapper getTypeMapper() {
            return new TypeMapper(this.getDtoPackage(), this.getAnnotation().mapping());
        }

        String getDtoPackage() {
            return String.join((CharSequence)".", Arrays.asList(this.getPackage(), this.getAnnotation().dtoPackage()));
        }

        String getPackage() {
            return GraphQLClientProcessor.this.processingEnv.getElementUtils().getPackageOf(this.element).toString();
        }

        Schema getSchema() {
            String value = this.getAnnotation().schema();
            File file = this.getSchemaFile();
            try {
                if (StringUtils.hasLength(value)) {
                    log.info("Reading schema {}", (Object)file);
                    return new Schema(this.getSchemaFile());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw new SchemaNotFoundException(file.getPath());
        }

        File getSchemaFile() {
            return GraphQLClientProcessor.this.getRoot().resolve(this.getAnnotation().schema()).toAbsolutePath().toFile();
        }

        public TypeElement getElement() {
            return this.element;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Input)) {
                return false;
            }
            Input other = (Input)o;
            TypeElement this$element = this.getElement();
            TypeElement other$element = other.getElement();
            return !(this$element == null ? other$element != null : !this$element.equals(other$element));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TypeElement $element = this.getElement();
            result = result * 59 + ($element == null ? 43 : $element.hashCode());
            return result;
        }

        public String toString() {
            return "GraphQLClientProcessor.Input(element=" + this.getElement() + ")";
        }

        public Input(TypeElement element) {
            this.element = element;
        }
    }
}

