/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.query;

import com.jacobmountain.graphql.client.exceptions.FieldNotFoundException;
import com.jacobmountain.graphql.client.utils.Schema;
import com.jacobmountain.graphql.client.utils.StringUtils;
import graphql.language.EnumTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ListType;
import graphql.language.NamedNode;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(QueryGenerator.class);
    private final Schema schema;
    private final int maxDepth;

    public QueryGenerator(Schema registry, int maxDepth) {
        this.schema = registry;
        this.maxDepth = maxDepth;
    }

    public String generateQuery(String request, String field, Set<String> params) {
        return this.doGenerateQuery(request, field, "query", params);
    }

    public String generateMutation(String request, String field, Set<String> params) {
        return this.doGenerateQuery(request, field, "mutation", params);
    }

    public String generateSubscription(String request, String field, Set<String> params) {
        return this.doGenerateQuery(request, field, "subscription", params);
    }

    private String doGenerateQuery(String request, String field, String type, Set<String> params) {
        FieldDefinition definition = this.schema.findField(field).orElseThrow(FieldNotFoundException.create(field));
        HashSet<String> args = new HashSet<String>();
        String inner = this.generateQueryRec(field, definition, params, new HashSet<String>(), 1, args).orElseThrow(RuntimeException::new);
        String collect = String.join((CharSequence)", ", args);
        if (!args.isEmpty()) {
            collect = "(" + collect + ")";
        }
        return this.generateQueryName(request, type, field) + collect + " { " + inner + " } ";
    }

    private String generateQueryName(String request, String type, String field) {
        if (StringUtils.isEmpty(request)) {
            request = StringUtils.capitalize(field);
        }
        return type + " " + request;
    }

    private String unwrap(Type<?> type) {
        if (type instanceof ListType) {
            return this.unwrap(((ListType)type).getType());
        }
        if (type instanceof NonNullType) {
            return this.unwrap(((NonNullType)type).getType());
        }
        return ((TypeName)type).getName();
    }

    Optional<String> generateQueryRec(String alias, FieldDefinition field, Set<String> params, Set<String> previouslyVisited, int depth, Set<String> argumentCollector) {
        String type = this.unwrap(field.getType());
        TypeDefinition typeDefinition = this.schema.getTypeDefinition(type).orElse(null);
        Optional<String> optionalArgs = this.generateFieldArgs(field, params, argumentCollector);
        if (!optionalArgs.isPresent() && !this.methodArgsContainAllNonNullArgs(field, params)) {
            return optionalArgs;
        }
        String args = optionalArgs.orElse("");
        if (Objects.isNull(typeDefinition) || typeDefinition.getChildren().isEmpty()) {
            return Optional.of(alias + args);
        }
        if (typeDefinition instanceof EnumTypeDefinition) {
            return Optional.of(alias);
        }
        if (depth >= this.maxDepth) {
            return Optional.empty();
        }
        HashSet visited = new HashSet();
        List children = Stream.of(this.getChildren(typeDefinition).peek(it -> visited.add(it.getName())).filter(it -> previouslyVisited.add(it.getName())).map(definition -> this.generateQueryRec(definition.getName(), (FieldDefinition)definition, params, (Set<String>)new HashSet<String>(), depth + 1, argumentCollector)).filter(Optional::isPresent).map(Optional::get), this.schema.getTypesImplementing(typeDefinition).map(interfac -> this.generateQueryRec((String)interfac, new FieldDefinition(interfac, (Type)new TypeName(interfac)), params, visited, depth, argumentCollector)).filter(Optional::isPresent).map(Optional::get).map(query -> "... on " + query)).flatMap(Function.identity()).collect(Collectors.toList());
        if (children.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(alias + args + " { " + String.join((CharSequence)" ", children) + " __typename }");
    }

    private boolean methodArgsContainAllNonNullArgs(FieldDefinition field, Collection<String> params) {
        return field.getInputValueDefinitions().stream().filter(input -> input.getType() instanceof NonNullType).allMatch(nonNull -> params.contains(nonNull.getName()));
    }

    private Stream<FieldDefinition> getChildren(TypeDefinition<?> typeDefinition) {
        return typeDefinition.getChildren().stream().map(it -> {
            String name = ((NamedNode)it).getName();
            Optional<Object> childDefinition = typeDefinition instanceof ObjectTypeDefinition ? this.schema.findField((ObjectTypeDefinition)typeDefinition, name) : (typeDefinition instanceof InterfaceTypeDefinition ? this.schema.findField((InterfaceTypeDefinition)typeDefinition, name) : Optional.empty());
            return childDefinition;
        }).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<String> generateFieldArgs(FieldDefinition field, Set<String> params, Set<String> argsCollector) {
        List args = field.getInputValueDefinitions();
        HashSet<String> finalParams = new HashSet<String>(params);
        String collect = args.stream().filter(o -> finalParams.remove(o.getName())).peek(arg -> {
            boolean nonNull = arg.getType() instanceof NonNullType;
            String type = this.unwrap(arg.getType());
            argsCollector.add("$" + arg.getName() + ": " + type + (nonNull ? "!" : ""));
        }).map(arg -> arg.getName() + ": $" + arg.getName()).collect(Collectors.joining(", "));
        if (StringUtils.isEmpty(collect)) {
            return Optional.empty();
        }
        return Optional.of("(" + collect + ")");
    }
}

