/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.modules;

import com.jacobmountain.graphql.client.TypeMapper;
import com.jacobmountain.graphql.client.dto.Response;
import com.jacobmountain.graphql.client.modules.AbstractStage;
import com.jacobmountain.graphql.client.utils.Schema;
import com.jacobmountain.graphql.client.utils.StringUtils;
import com.jacobmountain.graphql.client.visitor.MethodDetails;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import graphql.language.ObjectTypeDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class OptionalReturnStage
extends AbstractStage {
    public OptionalReturnStage(Schema schema, TypeMapper typeMapper) {
        super(schema, typeMapper);
    }

    @Override
    public List<CodeBlock> assemble(MethodDetails details) {
        ObjectTypeDefinition typeDefinition = this.getTypeDefinition(details);
        ArrayList<CodeBlock> ret = new ArrayList<CodeBlock>(Arrays.asList(CodeBlock.of((String)"return $T.ofNullable(thing)", (Object[])new Object[]{Optional.class}), CodeBlock.of((String)"map($T::getData)", (Object[])new Object[]{ClassName.get(Response.class)}), CodeBlock.of((String)"map($T::$L)", (Object[])new Object[]{this.typeMapper.getType(typeDefinition.getName()), StringUtils.camelCase("get", details.getField())})));
        if (!this.returnsOptional(details)) {
            ret.add(CodeBlock.of((String)"orElse(null)", (Object[])new Object[0]));
        }
        return Collections.singletonList(CodeBlock.join(ret, (String)"\n\t."));
    }

    private boolean returnsOptional(MethodDetails details) {
        return details.getReturnType() instanceof ParameterizedTypeName && ((ParameterizedTypeName)details.getReturnType()).rawType.equals((Object)ClassName.get(Optional.class));
    }
}

