/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.utils;

import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StringUtils {
    public static String capitalize(String word) {
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }

    public static String decapitalize(String word) {
        return word.substring(0, 1).toLowerCase() + word.substring(1);
    }

    public static String camelCase(String ... parts) {
        return Stream.concat(Stream.of(parts[0]).map(StringUtils::decapitalize), Stream.of(parts).skip(1L).map(StringUtils::capitalize)).collect(Collectors.joining());
    }

    public static String pascalCase(String ... parts) {
        return Stream.of(parts).map(StringUtils::capitalize).collect(Collectors.joining());
    }

    public static String enquote(String value) {
        return "\"" + value + "\"";
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().equals("");
    }

    public static boolean hasLength(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        int length = cs1.length();
        for (int i = 0; i < length; ++i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

