/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client;

import com.jacobmountain.graphql.client.TypeMapper;
import com.jacobmountain.graphql.client.modules.AbstractStage;
import com.jacobmountain.graphql.client.modules.ArgumentAssemblyStage;
import com.jacobmountain.graphql.client.modules.BlockingQueryStage;
import com.jacobmountain.graphql.client.modules.ClientDetails;
import com.jacobmountain.graphql.client.modules.OptionalReturnStage;
import com.jacobmountain.graphql.client.modules.ReactiveQueryStage;
import com.jacobmountain.graphql.client.modules.ReactiveReturnStage;
import com.jacobmountain.graphql.client.utils.AnnotationUtils;
import com.jacobmountain.graphql.client.utils.Schema;
import com.jacobmountain.graphql.client.utils.StringUtils;
import com.jacobmountain.graphql.client.visitor.ClientDetailsVisitor;
import com.jacobmountain.graphql.client.visitor.MethodDetails;
import com.jacobmountain.graphql.client.visitor.MethodDetailsVisitor;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientGenerator {
    private static final Logger log = LoggerFactory.getLogger(ClientGenerator.class);
    private final Filer filer;
    private final TypeMapper typeMapper;
    private final String packageName;
    private final Schema schema;
    private final AbstractStage arguments;
    private final AbstractStage query;
    private final AbstractStage returnResults;

    public ClientGenerator(Filer filer, TypeMapper typeMapper, String packageName, String dtoPackageName, Schema schema, boolean reactive) {
        this.filer = filer;
        this.typeMapper = typeMapper;
        this.packageName = packageName;
        this.schema = schema;
        this.arguments = new ArgumentAssemblyStage(dtoPackageName);
        if (reactive) {
            this.query = new ReactiveQueryStage(schema, typeMapper, dtoPackageName);
            this.returnResults = new ReactiveReturnStage(schema, typeMapper);
        } else {
            this.query = new BlockingQueryStage(schema, typeMapper, dtoPackageName);
            this.returnResults = new OptionalReturnStage(schema, typeMapper);
        }
    }

    public void generate(Element element, String suffix) {
        if (StringUtils.isEmpty(suffix)) {
            throw new IllegalArgumentException("Invalid suffix for implementation of client: " + element.getSimpleName());
        }
        ClientDetails details = element.accept(new ClientDetailsVisitor(), null);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(element.getSimpleName() + suffix)).addSuperinterface((TypeName)ClassName.get((TypeElement)((TypeElement)element))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationUtils.generated());
        Stream.of(this.arguments, this.query, this.returnResults).flatMap(it -> it.getTypeArguments().stream()).map(TypeVariableName::get).forEach(arg_0 -> ((TypeSpec.Builder)builder).addTypeVariable(arg_0));
        List<AbstractStage.MemberVariable> memberVariables = Stream.of(this.arguments, this.query, this.returnResults).map(it -> it.getMemberVariables(details)).flatMap(Collection::stream).peek(memberVariable -> builder.addField(memberVariable.getType(), memberVariable.getName(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL})).collect(Collectors.toList());
        builder.addMethod(this.generateConstructor(memberVariables));
        element.getEnclosedElements().stream().map(this::generateImpl).forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        this.writeToFile(builder.build());
    }

    private MethodSpec generateConstructor(List<AbstractStage.MemberVariable> variables) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        variables.forEach(var -> constructor.addParameter(var.getType(), var.getName(), new Modifier[0]).addStatement("this.$L = $L", new Object[]{var.getName(), var.getName()}));
        return constructor.build();
    }

    private MethodSpec generateImpl(Element method) {
        log.info("");
        MethodDetails details = method.accept(new MethodDetailsVisitor(this.schema), this.typeMapper);
        log.info("{}", (Object)details);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)method.getSimpleName().toString()).returns(details.getReturnType()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameters(details.getParameterSpec());
        this.arguments.assemble(details).forEach(arg_0 -> ((MethodSpec.Builder)builder).addStatement(arg_0));
        this.query.assemble(details).forEach(arg_0 -> ((MethodSpec.Builder)builder).addStatement(arg_0));
        this.returnResults.assemble(details).forEach(arg_0 -> ((MethodSpec.Builder)builder).addStatement(arg_0));
        return builder.build();
    }

    private void writeToFile(TypeSpec spec) throws Exception {
        JavaFile.builder((String)this.packageName, (TypeSpec)spec).indent("\t").skipJavaLangImports(true).build().writeTo(this.filer);
    }

    public ClientGenerator(Filer filer, TypeMapper typeMapper, String packageName, Schema schema, AbstractStage arguments, AbstractStage query, AbstractStage returnResults) {
        this.filer = filer;
        this.typeMapper = typeMapper;
        this.packageName = packageName;
        this.schema = schema;
        this.arguments = arguments;
        this.query = query;
        this.returnResults = returnResults;
    }
}

