/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.modules;

import com.jacobmountain.graphql.client.modules.AbstractStage;
import com.jacobmountain.graphql.client.utils.StringUtils;
import com.jacobmountain.graphql.client.visitor.MethodDetails;
import com.jacobmountain.graphql.client.visitor.Parameter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ArgumentAssemblyStage
extends AbstractStage {
    private final String dtoPackageName;

    public ArgumentAssemblyStage(String dtoPackageName) {
        super(null, null);
        this.dtoPackageName = dtoPackageName;
    }

    @Override
    public List<CodeBlock> assemble(MethodDetails details) {
        List<Parameter> parameters = details.getParameters();
        if (parameters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CodeBlock> ret = new ArrayList<CodeBlock>();
        ClassName type = ClassName.get((String)this.dtoPackageName, (String)details.getArgumentClassname(), (String[])new String[0]);
        ret.add(CodeBlock.of((String)"$T args = new $T()", (Object[])new Object[]{type, type}));
        details.getParameters().stream().map(this::setArgumentField).forEach(ret::add);
        return ret;
    }

    private CodeBlock setArgumentField(Parameter param) {
        String parameter = param.getName();
        String field = param.getField();
        CodeBlock value = CodeBlock.of((String)"$L", (Object[])new Object[]{parameter});
        if (!param.isNullable()) {
            value = CodeBlock.of((String)"$T.requireNonNull($L, $S)", (Object[])new Object[]{Objects.class, parameter, String.format("%s is not nullable", parameter)});
        }
        return CodeBlock.of((String)"args.set$L($L)", (Object[])new Object[]{StringUtils.capitalize(field), value});
    }
}

