/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.jacobmountain.graphql.client.utils.AnnotationUtils;
import com.jacobmountain.graphql.client.utils.StringUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import graphql.language.EnumValueDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoBuilder {
    private static final Logger log = LoggerFactory.getLogger(PojoBuilder.class);
    private TypeSpec.Builder builder;
    private Type type;
    private final String name;
    private final String packageName;
    private final List<String> fields = new ArrayList<String>();
    private final List<String> subTypes = new ArrayList<String>();

    protected PojoBuilder(String name, String packageName) {
        this.name = name;
        this.packageName = packageName;
    }

    public String getFQDN() {
        return String.format("%s.%s", this.packageName, this.name);
    }

    public static PojoBuilder newInterface(String name, String packageName) {
        return new PojoBuilder(name, packageName).interfac(name);
    }

    public static PojoBuilder newType(String name, String packageName) {
        return new PojoBuilder(name, packageName).clazz(name, false);
    }

    public PojoBuilder staTic() {
        this.builder.addModifiers(new Modifier[]{Modifier.STATIC});
        return this;
    }

    public static PojoBuilder newInput(String name, String packageName) {
        return new PojoBuilder(name, packageName).clazz(name, true);
    }

    public static PojoBuilder newEnum(String name, String packageName) {
        return new PojoBuilder(name, packageName).enumeration(name);
    }

    public static PojoBuilder newUnion(String name, String packageName) {
        return new PojoBuilder(name, packageName).union(name);
    }

    private PojoBuilder clazz(String name, boolean input) {
        log.info("{} {} {", (Object)(input ? "input" : "type"), (Object)name);
        this.type = Type.Class;
        this.builder = TypeSpec.classBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationUtils.generated());
        return this;
    }

    private PojoBuilder interfac(String name) {
        log.info("interface {} {", (Object)name);
        this.type = Type.Interface;
        this.builder = TypeSpec.interfaceBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationUtils.generated());
        return this;
    }

    private PojoBuilder union(String name) {
        this.type = Type.Union;
        this.builder = TypeSpec.interfaceBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationUtils.generated());
        return this;
    }

    private PojoBuilder enumeration(String name) {
        log.info("enum {} {", (Object)name);
        this.type = Type.Enum;
        this.builder = TypeSpec.enumBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC});
        return this;
    }

    public PojoBuilder withField(TypeName clazz, String name) {
        boolean keyword = SourceVersion.isKeyword(name);
        String finalName = name;
        if (keyword) {
            finalName = "_" + name;
        }
        if (clazz instanceof ClassName) {
            log.info("\t" + name + ": " + ((ClassName)clazz).simpleName());
        } else {
            log.info("\t" + name + ": " + clazz);
        }
        this.fields.add(finalName);
        if (!this.isInterface()) {
            this.builder.addField(FieldSpec.builder((TypeName)clazz, (String)finalName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpec.builder(JsonProperty.class).addMember("value", "\"$L\"", new Object[]{name}).build()).build());
        }
        this.withAccessors(clazz, finalName);
        return this;
    }

    public void withEnumValue(EnumValueDefinition it) {
        if (this.type == Type.Enum) {
            this.builder.addEnumConstant(it.getName());
            log.info("\t{}", (Object)it.getName());
        }
    }

    public boolean hasSubType(String type) {
        return this.subTypes.contains(type);
    }

    public PojoBuilder withSubType(String type) {
        this.subTypes.add(type);
        return this;
    }

    private void withAccessors(TypeName clazz, String name) {
        this.withGetter(clazz, name);
        if (!this.isInterface()) {
            this.withSetter(clazz, name);
        }
    }

    public PojoBuilder implement(String s) {
        this.builder.addSuperinterface((TypeName)ClassName.get((String)this.packageName, (String)s, (String[])new String[0]));
        return this;
    }

    private MethodSpec.Builder accessorBuilder(String name, String body, Object ... args) {
        MethodSpec.Builder getter = MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (!this.isInterface()) {
            getter.addStatement(body, args);
        } else {
            getter.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        return getter;
    }

    private void generateToString() {
        if (this.type == Type.Enum) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\"{ ");
        builder.append(this.name);
        for (String field : this.fields) {
            builder.append(" ");
            builder.append(field);
            builder.append(": \" + ");
            builder.append("this.");
            builder.append(field);
            builder.append(" + ");
            if (field.equals(this.fields.get(this.fields.size() - 1))) continue;
            builder.append("\",");
        }
        builder.append("\" }\"");
        MethodSpec toString = MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $L", new Object[]{builder}).build();
        this.builder.addMethod(toString);
    }

    private String createGetterName(String variable) {
        return StringUtils.camelCase("get", variable.replaceFirst("_", ""));
    }

    private void withGetter(TypeName clazz, String name) {
        String methodName = this.createGetterName(name);
        this.builder.addMethod(this.accessorBuilder(methodName, "return this.$L", name).returns(clazz).build());
    }

    private String createSetterName(String variable) {
        return StringUtils.camelCase("set", variable.replaceFirst("_", ""));
    }

    private void withSetter(TypeName clazz, String name) {
        String methodName = this.createSetterName(name);
        this.builder.addMethod(this.accessorBuilder(methodName, "this.$L = $L", name, "set").addParameter(clazz, "set", new Modifier[0]).returns(Void.TYPE).build());
    }

    private void generateEquals() {
        if (this.type == Type.Enum) {
            return;
        }
        String variable = StringUtils.camelCase("other", this.name);
        CodeBlock.Builder equals = CodeBlock.builder();
        for (int i = 0; i < this.fields.size(); ++i) {
            String field = this.fields.get(i);
            equals.add(CodeBlock.of((String)"$T.equals(this.$L, $L.$L())", (Object[])new Object[]{Objects.class, field, variable, this.createGetterName(field)}));
            if (i + 1 == this.fields.size()) continue;
            equals.add(" &&\n\t", new Object[0]);
        }
        if (this.fields.isEmpty()) {
            equals = CodeBlock.builder().add("true", new Object[0]);
        }
        this.builder.addMethod(MethodSpec.methodBuilder((String)"equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeName.OBJECT, "other", new Modifier[0]).returns(TypeName.BOOLEAN).addStatement("if (this == other) return true", new Object[0]).addStatement("if (other == null || getClass() != other.getClass()) return false", new Object[0]).addStatement("$L $L = ($L) other", new Object[]{this.name, variable, this.name}).addCode("return ", new Object[0]).addCode(equals.build()).addCode(";\n", new Object[0]).build());
    }

    boolean isInterface() {
        return this.type == Type.Interface || this.type == Type.Union;
    }

    public TypeSpec buildClass() {
        if (!this.isInterface()) {
            this.generateToString();
            this.generateEquals();
        } else {
            this.builder.addAnnotation(AnnotationUtils.JSON_TYPE_INFO);
            this.builder.addAnnotation(AnnotationUtils.jsonSubtypes(this.subTypes.toArray(new String[0])));
        }
        this.builder.addAnnotation(AnnotationSpec.builder((ClassName)AnnotationUtils.JSON_TYPE_NAME_ANNOTATION).addMember("value", StringUtils.enquote(this.name), new Object[0]).build());
        return this.builder.build();
    }

    public JavaFile build() {
        return JavaFile.builder((String)this.packageName, (TypeSpec)this.buildClass()).indent("\t").build();
    }

    public void finalise() {
        if (this.type == Type.Union) {
            log.info("union {} = {}", (Object)this.name, (Object)String.join((CharSequence)" | ", this.subTypes));
        } else {
            log.info("}");
        }
        log.info("");
    }

    static enum Type {
        Class,
        Interface,
        Enum,
        Union;

    }
}

