/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.query;

import com.jacobmountain.graphql.client.exceptions.FieldNotFoundException;
import com.jacobmountain.graphql.client.query.QueryContext;
import com.jacobmountain.graphql.client.query.filters.AllNonNullArgsFieldFilter;
import com.jacobmountain.graphql.client.query.filters.FieldDuplicationFilter;
import com.jacobmountain.graphql.client.query.filters.FieldFilter;
import com.jacobmountain.graphql.client.query.filters.MaxDepthFieldFilter;
import com.jacobmountain.graphql.client.query.filters.SelectionFieldFilter;
import com.jacobmountain.graphql.client.query.selectors.DefaultFieldSelector;
import com.jacobmountain.graphql.client.query.selectors.DelegatingFieldSelector;
import com.jacobmountain.graphql.client.query.selectors.InlineFragmentRenderer;
import com.jacobmountain.graphql.client.utils.Schema;
import com.jacobmountain.graphql.client.utils.StringUtils;
import com.jacobmountain.graphql.client.visitor.GraphQLFieldSelection;
import graphql.language.EnumTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.NonNullType;
import graphql.language.TypeDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(QueryGenerator.class);
    private final Schema schema;

    public QueryGenerator(Schema registry) {
        this.schema = registry;
    }

    public QueryBuilder query() {
        return new QueryBuilder("query");
    }

    public QueryBuilder mutation() {
        return new QueryBuilder("mutation");
    }

    public QueryBuilder subscription() {
        return new QueryBuilder("subscription");
    }

    private String doGenerateQuery(String request, String field, String type, Set<String> params, List<FieldFilter> filters) {
        FieldDefinition definition = this.schema.findField(field).orElseThrow(FieldNotFoundException.create(field));
        QueryContext root = new QueryContext(null, 0, definition, params, new HashSet<String>());
        String inner = this.generateFieldSelection(field, root, filters).orElseThrow(RuntimeException::new);
        String collect = String.join((CharSequence)", ", root.getArgs());
        if (!root.getArgs().isEmpty()) {
            collect = "(" + collect + ")";
        }
        return this.generateQueryName(request, type, field) + collect + " { " + inner + " }";
    }

    private String generateQueryName(String request, String type, String field) {
        if (StringUtils.isEmpty(request)) {
            request = StringUtils.capitalize(field);
        }
        return type + " " + request;
    }

    public Optional<String> generateFieldSelection(String alias, QueryContext context, List<FieldFilter> filters) {
        String type = Schema.unwrap(context.getFieldDefinition().getType());
        TypeDefinition typeDefinition = this.schema.getTypeDefinition(type).orElse(null);
        if (!filters.stream().allMatch(fi -> fi.shouldAddField(context))) {
            return Optional.empty();
        }
        String args = this.generateFieldArgs(context);
        if (Objects.isNull(typeDefinition) || typeDefinition.getChildren().isEmpty() || typeDefinition instanceof EnumTypeDefinition) {
            return Optional.of(alias + args);
        }
        return new DelegatingFieldSelector(new DefaultFieldSelector(this.schema, this), new InlineFragmentRenderer(this.schema, this)).selectFields(typeDefinition, context, filters).map(children -> alias + args + " " + children).findFirst();
    }

    private String generateFieldArgs(QueryContext context) {
        List args = context.getFieldDefinition().getInputValueDefinitions();
        HashSet<String> finalParams = new HashSet<String>(context.getParams());
        String collect = args.stream().filter(o -> finalParams.remove(o.getName())).peek(arg -> {
            boolean nonNull = arg.getType() instanceof NonNullType;
            String type = Schema.unwrap(arg.getType());
            context.newArg("$" + arg.getName() + ": " + type + (nonNull ? "!" : ""));
        }).map(arg -> arg.getName() + ": $" + arg.getName()).collect(Collectors.joining(", "));
        if (StringUtils.isEmpty(collect)) {
            return "";
        }
        return "(" + collect + ")";
    }

    public class QueryBuilder {
        private final String type;
        private final List<FieldFilter> filters = new ArrayList<FieldFilter>();

        QueryBuilder(String type) {
            this.type = type;
        }

        public QueryBuilder maxDepth(int maxDepth) {
            this.filters.add(new MaxDepthFieldFilter(maxDepth));
            return this;
        }

        public QueryBuilder select(List<GraphQLFieldSelection> selections) {
            this.filters.add(new SelectionFieldFilter(selections));
            return this;
        }

        public String build(String request, String field, Set<String> params) {
            this.filters.add(new AllNonNullArgsFieldFilter());
            this.filters.add(new FieldDuplicationFilter());
            return QueryGenerator.this.doGenerateQuery(request, field, this.type, params, this.filters);
        }
    }
}

