/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.modules;

import com.jacobmountain.graphql.client.TypeMapper;
import com.jacobmountain.graphql.client.dto.Response;
import com.jacobmountain.graphql.client.modules.AbstractStage;
import com.jacobmountain.graphql.client.modules.ClientDetails;
import com.jacobmountain.graphql.client.utils.Schema;
import com.jacobmountain.graphql.client.utils.StringUtils;
import com.jacobmountain.graphql.client.visitor.MethodDetails;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import graphql.language.ObjectTypeDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionalReturnStage
extends AbstractStage {
    private static final Logger log = LoggerFactory.getLogger(OptionalReturnStage.class);
    private static final ClassName RESPONSE_CLASS_NAME = ClassName.get(Response.class);

    public OptionalReturnStage(Schema schema, TypeMapper typeMapper) {
        super(schema, typeMapper);
    }

    @Override
    public List<CodeBlock> assemble(ClientDetails client, MethodDetails method) {
        if (ClassName.VOID.equals((Object)method.getReturnType())) {
            if (!method.isMutation()) {
                throw new IllegalArgumentException("void return type on a non mutation method");
            }
            return Collections.emptyList();
        }
        ObjectTypeDefinition typeDefinition = this.getTypeDefinition(method);
        ArrayList<CodeBlock> ret = new ArrayList<CodeBlock>();
        ret.add(CodeBlock.of((String)"return $T.ofNullable(thing)", (Object[])new Object[]{Optional.class}));
        ret.add(CodeBlock.of((String)"map($T::getData)", (Object[])new Object[]{RESPONSE_CLASS_NAME}));
        ret.add(CodeBlock.of((String)"map($T::$L)", (Object[])new Object[]{this.typeMapper.getType(typeDefinition.getName()), StringUtils.camelCase("get", method.getField())}));
        if (!method.returnsClass(Optional.class, new Class[0])) {
            ret.add(CodeBlock.of((String)"orElse(null)", (Object[])new Object[0]));
        }
        return Collections.singletonList(CodeBlock.join(ret, (String)"\n\t."));
    }
}

