/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.visitor;

import com.jacobmountain.graphql.client.annotations.GraphQLField;
import com.jacobmountain.graphql.client.utils.StringUtils;
import com.jacobmountain.graphql.client.visitor.Parameter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MethodDetails {
    private final String methodName;
    private final String requestName;
    private final TypeName returnType;
    private final String field;
    private final List<Parameter> parameters;
    private final List<GraphQLField> selection;
    private final boolean mutation;
    private final boolean subscription;
    private final int maxDepth;

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public List<ParameterSpec> getParameterSpec() {
        return this.parameters.stream().map(Parameter::toSpec).collect(Collectors.toList());
    }

    public boolean isQuery() {
        return !this.mutation && !this.subscription;
    }

    public boolean isMutation() {
        return this.mutation;
    }

    public boolean isSubscription() {
        return this.subscription;
    }

    public String toString() {
        String arguments = this.parameters.stream().map(param -> MessageFormat.format("{0} {1}", MethodDetails.getTypeString(param.getType()), param.getName())).collect(Collectors.joining(", "));
        return MessageFormat.format("{0} {1}({2})", MethodDetails.getTypeString(this.returnType), this.methodName, arguments);
    }

    private String getName() {
        return Optional.ofNullable(this.requestName).filter(StringUtils::hasLength).orElse(this.methodName);
    }

    public String getArgumentClassname() {
        return StringUtils.pascalCase(this.getName(), "By") + this.parameters.stream().map(Parameter::getName).map(xva$0 -> StringUtils.pascalCase(xva$0)).collect(Collectors.joining("And"));
    }

    public static String getTypeString(TypeName type) {
        if (type instanceof ClassName) {
            return ((ClassName)type).simpleName();
        }
        if (type instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)type;
            String raw = parameterizedTypeName.rawType.simpleName();
            String collect = parameterizedTypeName.typeArguments.stream().map(MethodDetails::getTypeString).collect(Collectors.joining(", "));
            return String.format("%s<%s>", raw, collect);
        }
        return type.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean returnsClass(Class<?> clazz, Class<?> ... nested) {
        if (this.returnType instanceof ParameterizedTypeName) {
            ParameterizedTypeName returnType = (ParameterizedTypeName)this.returnType;
            if (!returnType.rawType.equals((Object)ClassName.get(clazz))) return false;
            if (!Stream.of(nested).map(ClassName::get).allMatch(returnType.typeArguments::contains)) return false;
            return true;
        }
        if (!this.returnType.equals((Object)ClassName.get(clazz))) return false;
        if (nested.length != 0) return false;
        return true;
    }

    MethodDetails(String methodName, String requestName, TypeName returnType, String field, List<Parameter> parameters, List<GraphQLField> selection, boolean mutation, boolean subscription, int maxDepth) {
        this.methodName = methodName;
        this.requestName = requestName;
        this.returnType = returnType;
        this.field = field;
        this.parameters = parameters;
        this.selection = selection;
        this.mutation = mutation;
        this.subscription = subscription;
        this.maxDepth = maxDepth;
    }

    public static MethodDetailsBuilder builder() {
        return new MethodDetailsBuilder();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public TypeName getReturnType() {
        return this.returnType;
    }

    public String getField() {
        return this.field;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<GraphQLField> getSelection() {
        return this.selection;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public static class MethodDetailsBuilder {
        private String methodName;
        private String requestName;
        private TypeName returnType;
        private String field;
        private ArrayList<Parameter> parameters;
        private List<GraphQLField> selection;
        private boolean mutation;
        private boolean subscription;
        private int maxDepth;

        MethodDetailsBuilder() {
        }

        public MethodDetailsBuilder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public MethodDetailsBuilder requestName(String requestName) {
            this.requestName = requestName;
            return this;
        }

        public MethodDetailsBuilder returnType(TypeName returnType) {
            this.returnType = returnType;
            return this;
        }

        public MethodDetailsBuilder field(String field) {
            this.field = field;
            return this;
        }

        public MethodDetailsBuilder parameter(Parameter parameter) {
            if (this.parameters == null) {
                this.parameters = new ArrayList();
            }
            this.parameters.add(parameter);
            return this;
        }

        public MethodDetailsBuilder parameters(Collection<? extends Parameter> parameters) {
            if (parameters == null) {
                throw new NullPointerException("parameters cannot be null");
            }
            if (this.parameters == null) {
                this.parameters = new ArrayList();
            }
            this.parameters.addAll(parameters);
            return this;
        }

        public MethodDetailsBuilder clearParameters() {
            if (this.parameters != null) {
                this.parameters.clear();
            }
            return this;
        }

        public MethodDetailsBuilder selection(List<GraphQLField> selection) {
            this.selection = selection;
            return this;
        }

        public MethodDetailsBuilder mutation(boolean mutation) {
            this.mutation = mutation;
            return this;
        }

        public MethodDetailsBuilder subscription(boolean subscription) {
            this.subscription = subscription;
            return this;
        }

        public MethodDetailsBuilder maxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public MethodDetails build() {
            List<Parameter> parameters;
            switch (this.parameters == null ? 0 : this.parameters.size()) {
                case 0: {
                    parameters = Collections.emptyList();
                    break;
                }
                case 1: {
                    parameters = Collections.singletonList(this.parameters.get(0));
                    break;
                }
                default: {
                    parameters = Collections.unmodifiableList(new ArrayList<Parameter>(this.parameters));
                }
            }
            return new MethodDetails(this.methodName, this.requestName, this.returnType, this.field, parameters, this.selection, this.mutation, this.subscription, this.maxDepth);
        }

        public String toString() {
            return "MethodDetails.MethodDetailsBuilder(methodName=" + this.methodName + ", requestName=" + this.requestName + ", returnType=" + this.returnType + ", field=" + this.field + ", parameters=" + this.parameters + ", selection=" + this.selection + ", mutation=" + this.mutation + ", subscription=" + this.subscription + ", maxDepth=" + this.maxDepth + ")";
        }
    }
}

