/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.modules;

import com.jacobmountain.graphql.client.Fetcher;
import com.jacobmountain.graphql.client.Subscriber;
import com.jacobmountain.graphql.client.TypeMapper;
import com.jacobmountain.graphql.client.dto.Response;
import com.jacobmountain.graphql.client.exceptions.MissingAnnotationException;
import com.jacobmountain.graphql.client.modules.AbstractQueryStage;
import com.jacobmountain.graphql.client.modules.AbstractStage;
import com.jacobmountain.graphql.client.modules.ClientDetails;
import com.jacobmountain.graphql.client.query.QueryGenerator;
import com.jacobmountain.graphql.client.utils.Schema;
import com.jacobmountain.graphql.client.utils.StringUtils;
import com.jacobmountain.graphql.client.visitor.MethodDetails;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import graphql.language.ObjectTypeDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class BlockingQueryStage
extends AbstractQueryStage {
    private static final ClassName RESPONSE_CLASS_NAME = ClassName.get(Response.class);

    public BlockingQueryStage(QueryGenerator queryGenerator, Schema schema, TypeMapper typeMapper, String dtoPackageName) {
        super(queryGenerator, schema, typeMapper, dtoPackageName);
    }

    @Override
    public List<AbstractStage.MemberVariable> getMemberVariables(ClientDetails details) {
        ArrayList<AbstractStage.MemberVariable> vars = new ArrayList<AbstractStage.MemberVariable>();
        if (details.requiresFetcher()) {
            vars.add(AbstractStage.MemberVariable.builder().name("fetcher").type(this.getFetcherTypeName(Fetcher.class)).build());
        }
        if (details.requiresSubscriber()) {
            vars.add(AbstractStage.MemberVariable.builder().name("subscriber").type(this.getSubscriberTypeName(Subscriber.class)).build());
        }
        return vars;
    }

    @Override
    public List<CodeBlock> assemble(ClientDetails client, MethodDetails method) {
        CodeBlock queryCode;
        String member = method.isSubscription() ? "subscriber" : "fetcher";
        ObjectTypeDefinition query = this.getTypeDefinition(method);
        CodeBlock.Builder builder = CodeBlock.builder();
        if (method.isSubscription()) {
            CodeBlock unwrapLambda = this.unwrapResponseLambda(query, method);
            queryCode = this.generateQueryCode(method.getRequestName(), method, unwrapLambda);
        } else {
            queryCode = this.generateQueryCode(method.getRequestName(), method, new CodeBlock[0]);
            builder.add("$T thing = ", new Object[]{ParameterizedTypeName.get((ClassName)RESPONSE_CLASS_NAME, (TypeName[])new TypeName[]{this.typeMapper.getType(query.getName()), TypeVariableName.get((String)"Error")})});
        }
        return Collections.singletonList(builder.add("$L.$L", new Object[]{member, this.getMethod(method)}).add(queryCode).build());
    }

    private CodeBlock unwrapResponseLambda(ObjectTypeDefinition query, MethodDetails method) {
        return CodeBlock.builder().add("subscription -> ", new Object[0]).add("$T.ofNullable(subscription)", new Object[]{Optional.class}).add(".map($T::getData)", new Object[]{RESPONSE_CLASS_NAME}).add(".map($T::$L)", new Object[]{this.typeMapper.getType(query.getName()), StringUtils.camelCase("get", method.getField())}).add(".ifPresent($L)", new Object[]{method.getSubscriptionCallback().orElseThrow(() -> new MissingAnnotationException("Expected a callback parameter to marked with @GraphQLSubscriptionCallback"))}).build();
    }
}

