/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.pingdom;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.jakewharton.apibuilder.ApiBuilder;
import com.jakewharton.pingdom.PingdomApiService;
import com.jakewharton.pingdom.PingdomEnumeration;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class PingdomApiBuilder<T>
extends ApiBuilder {
    private static final String FIELD_VERSION = "version";
    private static final String BASE_URL = "https://api.pingdom.com";
    private static final String BASE_URI = "/api/{version}";
    static final long MILLISECONDS_IN_SECOND = 1000L;
    private static final double DEFAULT_VERSION = 2.0;
    private static final char SEPERATOR = ',';
    private final PingdomApiService service;
    private final TypeToken<T> token;
    private final HttpMethod method;
    private final Map<String, String> postParameters;

    public PingdomApiBuilder(PingdomApiService service, TypeToken<T> token, String urlFormat) {
        this(service, token, urlFormat, HttpMethod.Get, 2.0);
    }

    public PingdomApiBuilder(PingdomApiService service, TypeToken<T> token, String urlFormat, HttpMethod method) {
        this(service, token, urlFormat, method, 2.0);
    }

    public PingdomApiBuilder(PingdomApiService service, TypeToken<T> token, String urlFormat, double apiVersion) {
        this(service, token, urlFormat, HttpMethod.Get, apiVersion);
    }

    public PingdomApiBuilder(PingdomApiService service, TypeToken<T> token, String urlFormat, HttpMethod method, double apiVersion) {
        super("https://api.pingdom.com/api/{version}" + urlFormat);
        this.service = service;
        this.service.setApiVersion(apiVersion);
        this.token = token;
        this.method = method;
        this.postParameters = new HashMap<String, String>();
        this.field(FIELD_VERSION, Double.toString(apiVersion));
    }

    public final T fire() {
        return this.service.unmarshall(this.token, this.execute());
    }

    protected JsonElement execute() {
        String url = this.buildUrl();
        switch (this.method) {
            case Get: {
                return this.service.get(url);
            }
            case Post: {
                return this.service.post(url, this.postParameters);
            }
            case Delete: {
                return this.service.delete(url);
            }
            case Put: {
                return this.service.put(url, this.postParameters);
            }
        }
        throw new IllegalArgumentException("Unknown HttpMethod type " + this.method.toString());
    }

    protected ApiBuilder parameter(String name, Date value) {
        return this.parameter(name, Long.toString(value.getTime() / 1000L));
    }

    protected <K extends PingdomEnumeration> ApiBuilder parameter(String name, K value) {
        if (value == null || value.toString() == null || value.toString().length() == 0) {
            return this.parameter(name, "");
        }
        return this.parameter(name, value.toString());
    }

    protected <K> ApiBuilder parameter(String name, List<K> valueList) {
        StringBuilder builder = new StringBuilder();
        Iterator<K> iterator = valueList.iterator();
        while (iterator.hasNext()) {
            builder.append(PingdomApiBuilder.encodeUrl((String)iterator.next().toString()));
            if (!iterator.hasNext()) continue;
            builder.append(',');
        }
        return this.parameter(name, builder.toString());
    }

    protected <K extends PingdomEnumeration> ApiBuilder parameter(String name, Set<K> valueSet) {
        StringBuilder builder = new StringBuilder();
        Iterator<K> iterator = valueSet.iterator();
        while (iterator.hasNext()) {
            builder.append(ApiBuilder.encodeUrl((String)((PingdomEnumeration)iterator.next()).toString()));
            if (!iterator.hasNext()) continue;
            builder.append(',');
        }
        return this.parameter(name, builder.toString());
    }

    protected <K extends PingdomEnumeration> ApiBuilder field(String name, K value) {
        if (value == null || value.toString() == null || value.toString().length() == 0) {
            return this.field(name);
        }
        return this.field(name, value.toString());
    }

    protected PingdomApiBuilder<T> postParameter(String name, String value) {
        this.postParameters.put(name, value);
        return this;
    }

    protected PingdomApiBuilder<T> postParameter(String name, boolean value) {
        return this.postParameter(name, (PingdomEnumeration)((Object)Boolean.toString(value)));
    }

    protected PingdomApiBuilder<T> postParameter(String name, int value) {
        return this.postParameter(name, (PingdomEnumeration)((Object)Integer.toString(value)));
    }

    protected <K> PingdomApiBuilder<T> postParameter(String name, List<K> valueList) {
        StringBuilder builder = new StringBuilder();
        Iterator<K> iterator = valueList.iterator();
        while (iterator.hasNext()) {
            builder.append(PingdomApiBuilder.encodeUrl((String)iterator.next().toString()));
            if (!iterator.hasNext()) continue;
            builder.append(',');
        }
        return this.postParameter(name, (K)((Object)builder.toString()));
    }

    protected <K extends PingdomEnumeration> PingdomApiBuilder<T> postParameter(String name, K value) {
        return this.postParameter(name, (K)((Object)value.toString()));
    }

    protected static enum HttpMethod {
        Get,
        Post,
        Delete,
        Put;

    }
}

