/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.pingdom;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.jakewharton.apibuilder.ApiException;
import com.jakewharton.apibuilder.ApiService;
import com.jakewharton.pingdom.entities.Check;
import com.jakewharton.pingdom.entities.SummaryAverage;
import com.jakewharton.pingdom.enumerations.AlertStatus;
import com.jakewharton.pingdom.enumerations.AlertVia;
import com.jakewharton.pingdom.enumerations.BannerType;
import com.jakewharton.pingdom.enumerations.CheckStatus;
import com.jakewharton.pingdom.enumerations.CheckType;
import com.jakewharton.pingdom.enumerations.PerformanceResolution;
import com.jakewharton.pingdom.enumerations.PublicReportMonths;
import com.jakewharton.pingdom.enumerations.ReportFrequency;
import com.jakewharton.pingdom.enumerations.SharedReportType;
import com.jakewharton.pingdom.enumerations.SmsProvider;
import com.jakewharton.pingdom.enumerations.StateStatus;
import com.jakewharton.pingdom.util.Base64;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class PingdomApiService
extends ApiService {
    private static final int DEFAULT_TIMEOUT_CONNECT = 60000;
    private static final int DEFAULT_TIMEOUT_READ = 60000;
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_AUTHORIZATION_TYPE = "Basic";
    private static final String HEADER_APP_KEY = "App-Key";
    private static final Charset UTF_8_CHAR_SET = Charset.forName("UTF-8");
    private static final String HTTP_METHOD_PUT = "PUT";
    private final JsonParser parser = new JsonParser();
    private Double apiVersion;

    public PingdomApiService() {
        this.setConnectTimeout(60000);
        this.setReadTimeout(60000);
        this.acceptGzip();
    }

    public JsonObject get(String url) {
        return this.unmarshall(this.executeGet(url));
    }

    public JsonObject post(String url, Map<String, String> parameters) {
        return this.unmarshall(this.executePost(url, parameters));
    }

    public JsonObject delete(String url) {
        return this.unmarshall(this.executeDelete(url));
    }

    public JsonObject put(String url, Map<String, String> parameters) {
        String content = ApiService.getParametersString(parameters);
        return this.unmarshall(this.executeMethod(url, content, null, HTTP_METHOD_PUT, 200));
    }

    public void setAuthentication(String email, String password) {
        if (email == null || email.length() == 0) {
            throw new IllegalArgumentException("Email must not be empty.");
        }
        if (password == null || password.length() == 0) {
            throw new IllegalArgumentException("Password must not be empty.");
        }
        String source = email + ":" + password;
        String authentication = "Basic " + Base64.encodeBytes(source.getBytes());
        this.addRequestHeader(HEADER_AUTHORIZATION, authentication);
    }

    public void setAppKey(String value) {
        this.addRequestHeader(HEADER_APP_KEY, value);
    }

    public void setApiVersion(double apiVersion) {
        this.apiVersion = apiVersion;
    }

    protected <T> T unmarshall(TypeToken<T> typeToken, JsonElement response) {
        GsonBuilder gsonBuilder = PingdomApiService.getGsonBuilder();
        if (this.apiVersion != null) {
            gsonBuilder.setVersion(this.apiVersion.doubleValue());
        }
        return (T)gsonBuilder.create().fromJson(response, typeToken.getType());
    }

    protected JsonObject unmarshall(InputStream jsonContent) {
        try {
            JsonElement element = this.parser.parse((Reader)new InputStreamReader(jsonContent, UTF_8_CHAR_SET));
            if (element.isJsonObject()) {
                JsonObject jsonObject = element.getAsJsonObject();
                return jsonObject;
            }
            try {
                throw new ApiException("Unknown content found in response." + element);
            }
            catch (Exception e) {
                throw new ApiException((Throwable)e);
            }
        }
        finally {
            ApiService.closeStream((InputStream)jsonContent);
        }
    }

    static GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.setFieldNamingStrategy((FieldNamingStrategy)new PingdomFieldNamingStrategy());
        builder.registerTypeAdapter(Check.CheckTypeWrapper.class, (Object)new JsonDeserializer<Check.CheckTypeWrapper>(){

            public Check.CheckTypeWrapper deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                CheckType typeNative = null;
                Check.CheckTypeBase typeObject = null;
                if (json.isJsonPrimitive()) {
                    typeNative = CheckType.fromValue(json.getAsString());
                } else {
                    Map.Entry entry = (Map.Entry)json.getAsJsonObject().entrySet().iterator().next();
                    typeNative = CheckType.fromValue((String)entry.getKey());
                    typeObject = (Check.CheckTypeBase)context.deserialize((JsonElement)entry.getValue(), Check.CheckTypeBase.class);
                }
                return new Check.CheckTypeWrapper(typeNative, typeObject);
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new Date(json.getAsLong() * 1000L);
            }
        });
        builder.registerTypeAdapter(SummaryAverage.ResponseTime.AvgResponseWrapper.class, (Object)new JsonDeserializer<SummaryAverage.ResponseTime.AvgResponseWrapper>(){

            public SummaryAverage.ResponseTime.AvgResponseWrapper deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json.isJsonPrimitive()) {
                    return new SummaryAverage.ResponseTime.AvgResponseWrapper(json.getAsInt());
                }
                if (json.isJsonArray()) {
                    Type type = new TypeToken<List<SummaryAverage.ResponseTime.ProbeResponseTime>>(){}.getType();
                    return new SummaryAverage.ResponseTime.AvgResponseWrapper((List)context.deserialize((JsonElement)json.getAsJsonArray(), type));
                }
                throw new JsonParseException("Unknown 'average reponse' JSON: " + json.toString());
            }
        });
        builder.registerTypeAdapter(AlertStatus.class, (Object)new JsonDeserializer<AlertStatus>(){

            public AlertStatus deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return AlertStatus.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(AlertVia.class, (Object)new JsonDeserializer<AlertVia>(){

            public AlertVia deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return AlertVia.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(BannerType.class, (Object)new JsonDeserializer<BannerType>(){

            public BannerType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return BannerType.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(CheckStatus.class, (Object)new JsonDeserializer<CheckStatus>(){

            public CheckStatus deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return CheckStatus.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(CheckType.class, (Object)new JsonDeserializer<CheckType>(){

            public CheckType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return CheckType.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(PerformanceResolution.class, (Object)new JsonDeserializer<PerformanceResolution>(){

            public PerformanceResolution deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return PerformanceResolution.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(PublicReportMonths.class, (Object)new JsonDeserializer<PublicReportMonths>(){

            public PublicReportMonths deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return PublicReportMonths.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(ReportFrequency.class, (Object)new JsonDeserializer<ReportFrequency>(){

            public ReportFrequency deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return ReportFrequency.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(SharedReportType.class, (Object)new JsonDeserializer<SharedReportType>(){

            public SharedReportType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return SharedReportType.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(SmsProvider.class, (Object)new JsonDeserializer<SmsProvider>(){

            public SmsProvider deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return SmsProvider.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(StateStatus.class, (Object)new JsonDeserializer<StateStatus>(){

            public StateStatus deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return StateStatus.fromValue(json.getAsString());
            }
        });
        return builder;
    }

    private static final class PingdomFieldNamingStrategy
    implements FieldNamingStrategy {
        private PingdomFieldNamingStrategy() {
        }

        public String translateName(Field field) {
            return field.getName().toLowerCase();
        }
    }
}

