/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.pingdom;

import com.jakewharton.pingdom.PingdomApiService;
import com.jakewharton.pingdom.services.ActionsService;
import com.jakewharton.pingdom.services.AnalysisService;
import com.jakewharton.pingdom.services.CheckService;
import com.jakewharton.pingdom.services.ContactService;
import com.jakewharton.pingdom.services.ProbeService;
import com.jakewharton.pingdom.services.ReferenceService;
import com.jakewharton.pingdom.services.ReportsEmailService;
import com.jakewharton.pingdom.services.ReportsPublicService;
import com.jakewharton.pingdom.services.ReportsSharedService;
import com.jakewharton.pingdom.services.ResultsService;
import com.jakewharton.pingdom.services.ServerTimeService;
import com.jakewharton.pingdom.services.SettingsService;
import com.jakewharton.pingdom.services.SummaryAverageService;
import com.jakewharton.pingdom.services.SummaryOutageService;
import com.jakewharton.pingdom.services.SummaryPerformanceService;
import com.jakewharton.pingdom.services.SummaryProbeService;
import com.jakewharton.pingdom.services.TraceRouteService;

public class ServiceManager {
    private String appKeyValue;
    private String email;
    private String password;
    private Integer connectionTimeout;
    private Integer readTimeout;

    public ServiceManager setAuthentication(String email, String password) {
        this.email = email;
        this.password = password;
        return this;
    }

    public ServiceManager setAppKey(String value) {
        this.appKeyValue = value;
        return this;
    }

    public ServiceManager setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public ServiceManager setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    private void setupService(PingdomApiService service) {
        if (this.appKeyValue != null) {
            service.setAppKey(this.appKeyValue);
        }
        if (this.email != null && this.password != null) {
            service.setAuthentication(this.email, this.password);
        }
        if (this.connectionTimeout != null) {
            service.setConnectTimeout(this.connectionTimeout);
        }
        if (this.readTimeout != null) {
            service.setReadTimeout(this.readTimeout);
        }
    }

    public ActionsService actionsService() {
        ActionsService service = ServiceManager.newActionsService();
        this.setupService(service);
        return service;
    }

    public AnalysisService analysisService() {
        AnalysisService service = ServiceManager.newAnalysisService();
        this.setupService(service);
        return service;
    }

    public CheckService checkService() {
        CheckService service = ServiceManager.newCheckService();
        this.setupService(service);
        return service;
    }

    public ContactService contactService() {
        ContactService service = ServiceManager.newContactService();
        this.setupService(service);
        return service;
    }

    public ProbeService probeService() {
        ProbeService service = ServiceManager.newProbeService();
        this.setupService(service);
        return service;
    }

    public ReferenceService referenceService() {
        ReferenceService service = ServiceManager.newReferenceService();
        this.setupService(service);
        return service;
    }

    public ReportsEmailService reportsEmailService() {
        ReportsEmailService service = ServiceManager.newReportsEmailService();
        this.setupService(service);
        return service;
    }

    public ReportsPublicService reportsPublicService() {
        ReportsPublicService service = ServiceManager.newReportsPublicService();
        this.setupService(service);
        return service;
    }

    public ReportsSharedService reportsSharedService() {
        ReportsSharedService service = ServiceManager.newReportsSharedService();
        this.setupService(service);
        return service;
    }

    public ResultsService resultsService() {
        ResultsService service = ServiceManager.newResultsService();
        this.setupService(service);
        return service;
    }

    public ServerTimeService serverTimeService() {
        ServerTimeService service = ServiceManager.newServerTimeService();
        this.setupService(service);
        return service;
    }

    public SettingsService settingsService() {
        SettingsService service = ServiceManager.newSettingsService();
        this.setupService(service);
        return service;
    }

    public SummaryAverageService summaryAverageService() {
        SummaryAverageService service = ServiceManager.newSummaryAverageService();
        this.setupService(service);
        return service;
    }

    public SummaryOutageService summaryOutageService() {
        SummaryOutageService service = ServiceManager.newSummaryOutageService();
        this.setupService(service);
        return service;
    }

    public SummaryPerformanceService summaryPerformanceService() {
        SummaryPerformanceService service = ServiceManager.newSummaryPerformanceService();
        this.setupService(service);
        return service;
    }

    public SummaryProbeService summaryProbeService() {
        SummaryProbeService service = ServiceManager.newSummaryProbeService();
        this.setupService(service);
        return service;
    }

    public TraceRouteService traceRouteService() {
        TraceRouteService service = ServiceManager.newTraceRouteService();
        this.setupService(service);
        return service;
    }

    public static final ActionsService newActionsService() {
        return new ActionsService();
    }

    public static final AnalysisService newAnalysisService() {
        return new AnalysisService();
    }

    public static final CheckService newCheckService() {
        return new CheckService();
    }

    public static final ContactService newContactService() {
        return new ContactService();
    }

    public static final ProbeService newProbeService() {
        return new ProbeService();
    }

    public static final ReferenceService newReferenceService() {
        return new ReferenceService();
    }

    public static final ReportsEmailService newReportsEmailService() {
        return new ReportsEmailService();
    }

    public static final ReportsPublicService newReportsPublicService() {
        return new ReportsPublicService();
    }

    public static final ReportsSharedService newReportsSharedService() {
        return new ReportsSharedService();
    }

    public static final ResultsService newResultsService() {
        return new ResultsService();
    }

    public static final ServerTimeService newServerTimeService() {
        return new ServerTimeService();
    }

    public static final SettingsService newSettingsService() {
        return new SettingsService();
    }

    public static final SummaryAverageService newSummaryAverageService() {
        return new SummaryAverageService();
    }

    public static final SummaryOutageService newSummaryOutageService() {
        return new SummaryOutageService();
    }

    public static final SummaryPerformanceService newSummaryPerformanceService() {
        return new SummaryPerformanceService();
    }

    public static final SummaryProbeService newSummaryProbeService() {
        return new SummaryProbeService();
    }

    public static final TraceRouteService newTraceRouteService() {
        return new TraceRouteService();
    }
}

