/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.pingdom.enumerations;

import com.jakewharton.pingdom.PingdomEnumeration;
import java.util.HashMap;
import java.util.Map;

public enum CheckType implements PingdomEnumeration
{
    Http("http"),
    HttpCustom("httpcustom"),
    Tcp("tcp"),
    Ping("ping"),
    Dns("dns"),
    Udp("udp"),
    Smtp("smtp"),
    Pop3("pop3"),
    Imap("imap");

    private final String value;
    private static final Map<String, CheckType> STRING_MAPPING;

    private CheckType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static CheckType fromValue(String value) {
        return STRING_MAPPING.get(value);
    }

    static {
        STRING_MAPPING = new HashMap<String, CheckType>();
        for (CheckType status : CheckType.values()) {
            STRING_MAPPING.put(status.toString(), status);
        }
    }
}

