/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.pingdom.services;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.jakewharton.pingdom.PingdomApiBuilder;
import com.jakewharton.pingdom.PingdomApiService;
import com.jakewharton.pingdom.entities.Check;
import com.jakewharton.pingdom.entities.Message;
import com.jakewharton.pingdom.enumerations.CheckType;
import java.util.List;

public class CheckService
extends PingdomApiService {
    public ListBuilder list() {
        return new ListBuilder(this);
    }

    public GetBuilder get(int checkId) {
        return new GetBuilder(this, checkId);
    }

    public CreateBuilder create(String name, String host, CheckType type) {
        return new CreateBuilder(this, name, host, type);
    }

    public DeleteBuilder delete(int checkId) {
        return new DeleteBuilder(this, checkId);
    }

    public static final class DeleteBuilder
    extends PingdomApiBuilder<Message> {
        private static final String FIELD_CHECK_ID = "checkid";
        private static final String URI = "/checks/{checkid}";

        private DeleteBuilder(CheckService service, int checkId) {
            super((PingdomApiService)service, new TypeToken<Message>(){}, URI, PingdomApiBuilder.HttpMethod.Delete);
            this.field(FIELD_CHECK_ID, checkId);
        }
    }

    public static final class CreateBuilder
    extends PingdomApiBuilder<Check> {
        private static final String POST_NAME = "name";
        private static final String POST_HOST = "host";
        private static final String POST_TYPE = "type";
        private static final String POST_PAUSED = "paused";
        private static final String POST_RESOLUTION = "resolution";
        private static final String POST_CONTACT_IDS = "contactids";
        private static final String POST_SEND_TO_EMAIL = "sendtoemail";
        private static final String POST_SEND_TO_SMS = "sendtosms";
        private static final String POST_SEND_TO_TWITTER = "sendtotwitter";
        private static final String POST_SEND_TO_IPHONE = "sendtoiphone";
        private static final String POST_SEND_NOTIFICATION_WHEN_DOWN = "sendnotificationwhendown";
        private static final String POST_NOTIFY_AGAIN_EVERY = "notifyagainevery";
        private static final String POST_NOTIFY_WHEN_BACK_UP = "notifywhenbackup";
        private static final String URI = "/checks";

        private CreateBuilder(CheckService service, String name, String host, CheckType type) {
            super((PingdomApiService)service, new TypeToken<Check>(){}, URI, PingdomApiBuilder.HttpMethod.Post);
            this.postParameter(POST_NAME, name);
            this.postParameter(POST_HOST, host);
            this.postParameter(POST_TYPE, type);
        }

        @Override
        protected JsonElement execute() {
            return super.execute().getAsJsonObject().get("check");
        }

        public CreateBuilder paused(boolean value) {
            this.postParameter(POST_PAUSED, value);
            return this;
        }

        public CreateBuilder resolution(int minutes) {
            this.postParameter(POST_RESOLUTION, minutes);
            return this;
        }

        public CreateBuilder contactIds(List<Integer> list) {
            this.postParameter(POST_CONTACT_IDS, list);
            return this;
        }

        public CreateBuilder sendToEmail(boolean value) {
            this.postParameter(POST_SEND_TO_EMAIL, value);
            return this;
        }

        public CreateBuilder sendToSms(boolean value) {
            this.postParameter(POST_SEND_TO_SMS, value);
            return this;
        }

        public CreateBuilder sendToTwitter(boolean value) {
            this.postParameter(POST_SEND_TO_TWITTER, value);
            return this;
        }

        public CreateBuilder sendToIPhone(boolean value) {
            this.postParameter(POST_SEND_TO_IPHONE, value);
            return this;
        }

        public CreateBuilder sendNotificationWhenDown(int count) {
            this.postParameter(POST_SEND_NOTIFICATION_WHEN_DOWN, count);
            return this;
        }

        public CreateBuilder notifyAgainEvery(int count) {
            this.postParameter(POST_NOTIFY_AGAIN_EVERY, count);
            return this;
        }

        public CreateBuilder notifyWhenBackUp(boolean value) {
            this.postParameter(POST_NOTIFY_WHEN_BACK_UP, value);
            return this;
        }
    }

    public static final class GetBuilder
    extends PingdomApiBuilder<Check> {
        private static final String FIELD_CHECK_ID = "checkid";
        private static final String URI = "/checks/{checkid}";

        private GetBuilder(CheckService service, int checkId) {
            super(service, new TypeToken<Check>(){}, URI);
            this.field(FIELD_CHECK_ID, checkId);
        }

        @Override
        protected JsonElement execute() {
            return super.execute().getAsJsonObject().get("check");
        }
    }

    public static final class ListBuilder
    extends PingdomApiBuilder<List<Check>> {
        private static final String PARAM_LIMIT = "limit";
        private static final String PARAM_OFFSET = "offset";
        private static final String URI = "/checks";
        private static final int MAX_LIMIT = 250000;

        private ListBuilder(CheckService service) {
            super(service, new TypeToken<List<Check>>(){}, URI);
        }

        @Override
        protected JsonElement execute() {
            return super.execute().getAsJsonObject().get("checks").getAsJsonArray();
        }

        public ListBuilder limit(int limit) {
            if (limit > 250000) {
                throw new IllegalArgumentException("Value must be less than or equal to 250000");
            }
            this.parameter(PARAM_LIMIT, limit);
            return this;
        }

        public ListBuilder offset(int offset) {
            if (!this.hasParameter(PARAM_LIMIT)) {
                throw new IllegalArgumentException("Requires that a limit be set.");
            }
            this.parameter(PARAM_OFFSET, offset);
            return this;
        }
    }
}

