/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.pingdom.services;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.jakewharton.pingdom.PingdomApiBuilder;
import com.jakewharton.pingdom.PingdomApiService;
import com.jakewharton.pingdom.entities.Contact;
import com.jakewharton.pingdom.entities.Message;
import java.util.List;

public class ContactService
extends PingdomApiService {
    public ListBuilder list() {
        return new ListBuilder(this);
    }

    public CreateBuilder create(String name) {
        return new CreateBuilder(this, name);
    }

    public ModifyBuilder modify(int contactId) {
        return new ModifyBuilder(this, contactId);
    }

    public DeleteBuilder delete(int contactId) {
        return new DeleteBuilder(this, contactId);
    }

    public static final class DeleteBuilder
    extends PingdomApiBuilder<Message> {
        private static final String FIELD_CONTACT_ID = "contactid";
        private static final String URI = "/contacts/{contactid}";

        private DeleteBuilder(ContactService service, int contactId) {
            super((PingdomApiService)service, new TypeToken<Message>(){}, URI, PingdomApiBuilder.HttpMethod.Delete);
            this.field(FIELD_CONTACT_ID, contactId);
        }
    }

    public static final class ModifyBuilder
    extends PingdomApiBuilder<Message> {
        private static final String POST_NAME = "name";
        private static final String POST_EMAIL = "email";
        private static final String POST_CELL_PHONE = "cellphone";
        private static final String POST_COUNTRY_CODE = "countrycode";
        private static final String POST_COUNTRY_ISO = "countryiso";
        private static final String POST_DEFAULT_SMS_PROVIDER = "defaultsmsprovider";
        private static final String POST_DIRECT_TWITTER = "directtwitter";
        private static final String POST_TWITTER_USER = "twitteruser";
        private static final String FIELD_CONTACT_ID = "contactid";
        private static final String URI = "/contacts/{contactid}";

        private ModifyBuilder(ContactService service, int contactId) {
            super((PingdomApiService)service, new TypeToken<Message>(){}, URI, PingdomApiBuilder.HttpMethod.Put);
            this.field(FIELD_CONTACT_ID, contactId);
        }

        public ModifyBuilder name(String name) {
            this.postParameter(POST_NAME, name);
            return this;
        }

        public ModifyBuilder email(String email) {
            this.postParameter(POST_EMAIL, email);
            return this;
        }

        public ModifyBuilder cellPhone(String cellPhone) {
            this.postParameter(POST_CELL_PHONE, cellPhone);
            return this;
        }

        public ModifyBuilder countryCode(String countryCode) {
            this.postParameter(POST_COUNTRY_CODE, countryCode);
            return this;
        }

        public ModifyBuilder countryIso(String countryIso) {
            this.postParameter(POST_COUNTRY_ISO, countryIso);
            return this;
        }

        public ModifyBuilder defaultSmsProvider(String defaultSmsProvider) {
            this.postParameter(POST_DEFAULT_SMS_PROVIDER, defaultSmsProvider);
            return this;
        }

        public ModifyBuilder directTwitter(boolean directTwitter) {
            this.postParameter(POST_DIRECT_TWITTER, directTwitter);
            return this;
        }

        public ModifyBuilder twitterUser(String twitterUser) {
            this.postParameter(POST_TWITTER_USER, twitterUser);
            return this;
        }
    }

    public static final class CreateBuilder
    extends PingdomApiBuilder<Contact> {
        private static final String POST_NAME = "name";
        private static final String POST_EMAIL = "email";
        private static final String POST_CELL_PHONE = "cellphone";
        private static final String POST_COUNTRY_CODE = "countrycode";
        private static final String POST_COUNTRY_ISO = "countryiso";
        private static final String POST_DEFAULT_SMS_PROVIDER = "defaultsmsprovider";
        private static final String POST_DIRECT_TWITTER = "directtwitter";
        private static final String POST_TWITTER_USER = "twitteruser";
        private static final String URI = "/contacts";

        private CreateBuilder(ContactService service, String name) {
            super((PingdomApiService)service, new TypeToken<Contact>(){}, URI, PingdomApiBuilder.HttpMethod.Post);
            this.postParameter(POST_NAME, name);
        }

        @Override
        protected JsonElement execute() {
            return super.execute().getAsJsonObject().get("contact");
        }

        public CreateBuilder email(String email) {
            this.postParameter(POST_EMAIL, email);
            return this;
        }

        public CreateBuilder cellPhone(String cellPhone) {
            this.postParameter(POST_CELL_PHONE, cellPhone);
            return this;
        }

        public CreateBuilder countryCode(String countryCode) {
            this.postParameter(POST_COUNTRY_CODE, countryCode);
            return this;
        }

        public CreateBuilder countryIso(String countryIso) {
            this.postParameter(POST_COUNTRY_ISO, countryIso);
            return this;
        }

        public CreateBuilder defaultSmsProvider(String defaultSmsProvider) {
            this.postParameter(POST_DEFAULT_SMS_PROVIDER, defaultSmsProvider);
            return this;
        }

        public CreateBuilder directTwitter(boolean directTwitter) {
            this.postParameter(POST_DIRECT_TWITTER, directTwitter);
            return this;
        }

        public CreateBuilder twitterUser(String twitterUser) {
            this.postParameter(POST_TWITTER_USER, twitterUser);
            return this;
        }
    }

    public static final class ListBuilder
    extends PingdomApiBuilder<List<Contact>> {
        private static final String PARAM_LIMIT = "limit";
        private static final String PARAM_OFFSET = "offset";
        private static final String URI = "/contacts";

        private ListBuilder(ContactService service) {
            super(service, new TypeToken<List<Contact>>(){}, URI);
        }

        @Override
        protected JsonElement execute() {
            return super.execute().getAsJsonObject().get("contacts").getAsJsonArray();
        }

        public ListBuilder limit(int limit) {
            this.parameter(PARAM_LIMIT, limit);
            return this;
        }

        public ListBuilder offset(int offset) {
            if (!this.hasParameter(PARAM_LIMIT)) {
                throw new IllegalArgumentException("Requires that a limit be set.");
            }
            this.parameter(PARAM_OFFSET, offset);
            return this;
        }
    }
}

