/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.pingdom.services;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.jakewharton.pingdom.PingdomApiBuilder;
import com.jakewharton.pingdom.PingdomApiService;
import com.jakewharton.pingdom.entities.Message;
import com.jakewharton.pingdom.entities.ReportSubscription;
import com.jakewharton.pingdom.enumerations.ReportFrequency;
import java.util.List;

public class ReportsEmailService
extends PingdomApiService {
    public ListBuilder list() {
        return new ListBuilder(this);
    }

    public CreateBuilder create(String name) {
        return new CreateBuilder(this, name);
    }

    public ModifyBuilder modify(int reportId) {
        return new ModifyBuilder(this, reportId);
    }

    public DeleteBuilder delete(int reportId) {
        return new DeleteBuilder(this, reportId);
    }

    public static final class DeleteBuilder
    extends PingdomApiBuilder<Message> {
        private static final String FIELD_REPORT_ID = "reportid";
        private static final String URI = "/reports.emamil/{reportid}";

        private DeleteBuilder(ReportsEmailService service, int reportId) {
            super((PingdomApiService)service, new TypeToken<Message>(){}, URI, PingdomApiBuilder.HttpMethod.Delete);
            this.field(FIELD_REPORT_ID, reportId);
        }
    }

    public static final class ModifyBuilder
    extends PingdomApiBuilder<Message> {
        private static final String POST_NAME = "name";
        private static final String POST_CHECK_ID = "checkid";
        private static final String POST_FREQUENCY = "frequency";
        private static final String POST_CONTACT_IDS = "contactids";
        private static final String POST_ADDITIONAL_EMAILS = "additionalemails";
        private static final String FIELD_REPORT_ID = "reportid";
        private static final String URI = "/reports.email/{reportid}";

        private ModifyBuilder(ReportsEmailService service, int reportId) {
            super((PingdomApiService)service, new TypeToken<Message>(){}, URI, PingdomApiBuilder.HttpMethod.Put);
            this.field(FIELD_REPORT_ID, reportId);
        }

        public ModifyBuilder name(String name) {
            this.postParameter(POST_NAME, name);
            return this;
        }

        public ModifyBuilder checkId(int checkId) {
            this.postParameter(POST_CHECK_ID, checkId);
            return this;
        }

        public ModifyBuilder frequency(ReportFrequency frequency) {
            this.postParameter(POST_FREQUENCY, frequency);
            return this;
        }

        public ModifyBuilder contactIds(List<Integer> contactIds) {
            this.postParameter(POST_CONTACT_IDS, contactIds);
            return this;
        }

        public ModifyBuilder additionalEmails(List<String> additionalEmails) {
            this.postParameter(POST_ADDITIONAL_EMAILS, additionalEmails);
            return this;
        }
    }

    public static final class CreateBuilder
    extends PingdomApiBuilder<Message> {
        private static final String POST_NAME = "name";
        private static final String POST_CHECK_ID = "checkid";
        private static final String POST_FREQUENCY = "frequency";
        private static final String POST_CONTACT_IDS = "contactids";
        private static final String POST_ADDITIONAL_EMAILS = "additionalemails";
        private static final String URI = "/reports.email";

        private CreateBuilder(ReportsEmailService service, String name) {
            super((PingdomApiService)service, new TypeToken<Message>(){}, URI, PingdomApiBuilder.HttpMethod.Post);
            this.postParameter(POST_NAME, name);
        }

        public CreateBuilder checkId(int checkId) {
            this.postParameter(POST_CHECK_ID, checkId);
            return this;
        }

        public CreateBuilder frequency(ReportFrequency frequency) {
            this.postParameter(POST_FREQUENCY, frequency);
            return this;
        }

        public CreateBuilder contactIds(List<Integer> contactIds) {
            this.postParameter(POST_CONTACT_IDS, contactIds);
            return this;
        }

        public CreateBuilder additionalEmails(List<String> additionalEmails) {
            this.postParameter(POST_ADDITIONAL_EMAILS, additionalEmails);
            return this;
        }
    }

    public static final class ListBuilder
    extends PingdomApiBuilder<List<ReportSubscription>> {
        private static final String URI = "/reports.email";

        private ListBuilder(ReportsEmailService service) {
            super(service, new TypeToken<List<ReportSubscription>>(){}, URI);
        }

        @Override
        protected JsonElement execute() {
            return super.execute().getAsJsonObject().get("subscription").getAsJsonArray();
        }
    }
}

