/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.pingdom.services;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.jakewharton.pingdom.PingdomApiBuilder;
import com.jakewharton.pingdom.PingdomApiService;
import com.jakewharton.pingdom.entities.Message;
import com.jakewharton.pingdom.entities.ReportShared;
import com.jakewharton.pingdom.enumerations.SharedReportType;
import java.util.List;

public class ReportsSharedService
extends PingdomApiService {
    public GetBuilder get() {
        return new GetBuilder(this);
    }

    public CreateBuilder create() {
        return new CreateBuilder(this);
    }

    public DeleteBuilder delete(int reportId) {
        return new DeleteBuilder(this, reportId);
    }

    public static final class DeleteBuilder
    extends PingdomApiBuilder<Message> {
        private static final String FIELD_REPORT_ID = "reportid";
        private static final String URI = "/reports.shared/{reportid}";

        private DeleteBuilder(ReportsSharedService service, int reportId) {
            super((PingdomApiService)service, new TypeToken<Message>(){}, URI, PingdomApiBuilder.HttpMethod.Delete);
            this.field(FIELD_REPORT_ID, reportId);
        }
    }

    public static final class CreateBuilder
    extends PingdomApiBuilder<Message> {
        private static final String POST_SHARED_TYPE = "sharedtype";
        private static final String POST_CHECK_ID = "checkid";
        private static final String POST_AUTO = "auto";
        private static final String POST_FROM_YEAR = "fromyear";
        private static final String POST_FROM_MONTH = "frommonth";
        private static final String POST_FROM_DAY = "fromday";
        private static final String POST_TO_YEAR = "toyear";
        private static final String POST_TO_MONTH = "tomonth";
        private static final String POST_TO_DAY = "today";
        private static final String URI = "/reports.shared";

        private CreateBuilder(ReportsSharedService service) {
            super((PingdomApiService)service, new TypeToken<Message>(){}, URI, PingdomApiBuilder.HttpMethod.Post);
        }

        public CreateBuilder sharedType(SharedReportType sharedType) {
            this.postParameter(POST_SHARED_TYPE, sharedType);
            return this;
        }

        public CreateBuilder checkId(int checkId) {
            this.postParameter(POST_CHECK_ID, checkId);
            return this;
        }

        public CreateBuilder auto(boolean auto) {
            this.postParameter(POST_AUTO, auto);
            return this;
        }

        public CreateBuilder fromYear(int fromYear) {
            this.postParameter(POST_FROM_YEAR, fromYear);
            return this;
        }

        public CreateBuilder fromMonth(int fromMonth) {
            this.postParameter(POST_FROM_MONTH, fromMonth);
            return this;
        }

        public CreateBuilder fromDay(int fromDay) {
            this.postParameter(POST_FROM_DAY, fromDay);
            return this;
        }

        public CreateBuilder toYear(int toYear) {
            this.postParameter(POST_TO_YEAR, toYear);
            return this;
        }

        public CreateBuilder toMonth(int toMonth) {
            this.postParameter(POST_TO_MONTH, toMonth);
            return this;
        }

        public CreateBuilder toDay(int toDay) {
            this.postParameter(POST_TO_DAY, toDay);
            return this;
        }
    }

    public static final class GetBuilder
    extends PingdomApiBuilder<List<ReportShared>> {
        private static final String URI = "/reports.shared";

        private GetBuilder(ReportsSharedService service) {
            super(service, new TypeToken<List<ReportShared>>(){}, URI);
        }

        @Override
        protected JsonElement execute() {
            return super.execute().getAsJsonObject().get("shared");
        }
    }
}

